/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video;

import android.content.Context;
import android.hardware.Camera;
import com.amity.github.faucamp.simplertmp.RtmpHandler;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.video.AmityCameraView;
import com.amity.socialcloud.sdk.video.AmityStreamBroadcasterConfiguration;
import com.amity.socialcloud.sdk.video.StreamBroadcaster;
import com.amity.socialcloud.sdk.video.domain.CreateVideoStreamingUC;
import com.amity.socialcloud.sdk.video.domain.DisposeVideoStreamingUC;
import com.amity.socialcloud.sdk.video.domain.GetVideoStreamingUC;
import com.amity.socialcloud.sdk.video.listener.DefaultEncodeHandlerListener;
import com.amity.socialcloud.sdk.video.listener.DefaultRecordHandlerListener;
import com.amity.socialcloud.sdk.video.listener.EkoRtmpListener;
import com.amity.socialcloud.sdk.video.model.AmityBroadcasterData;
import com.amity.socialcloud.sdk.video.model.AmityStreamBroadcasterState;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.single.SingleTimer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.ossrs.yasea.SrsEncodeHandler;
import net.ossrs.yasea.SrsPublisher;
import net.ossrs.yasea.SrsRecordHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001 B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcaster;", "Lcom/amity/socialcloud/sdk/video/StreamBroadcaster;", "srsPublisher", "Lnet/ossrs/yasea/SrsPublisher;", "(Lnet/ossrs/yasea/SrsPublisher;)V", "broadcasterData", "Lcom/amity/socialcloud/sdk/video/model/AmityBroadcasterData;", "configuration", "Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcasterConfiguration;", "isCameraStart", "", "getStateFlowable", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/video/model/AmityStreamBroadcasterState;", "pausePublish", "", "refreshCamera", "resumePublish", "startAudio", "startPreview", "startPublish", "streamId", "", "startPublishNewStream", "title", "description", "stopAudio", "stopPreview", "stopPublish", "stopPublishWithNoInternet", "switchCamera", "updateConfiguration", "Builder", "amity-video-publisher_release"})
public final class AmityStreamBroadcaster
implements StreamBroadcaster {
    @NotNull
    private final SrsPublisher srsPublisher;
    @Nullable
    private AmityBroadcasterData broadcasterData;
    private boolean isCameraStart;
    private AmityStreamBroadcasterConfiguration configuration;

    private AmityStreamBroadcaster(SrsPublisher srsPublisher) {
        this.srsPublisher = srsPublisher;
    }

    @Override
    public void startPreview() {
        if (!this.isCameraStart) {
            this.isCameraStart = true;
            new SingleTimer(300L, TimeUnit.MILLISECONDS, AndroidSchedulers.mainThread()).doOnSuccess(new Consumer(this){
                final /* synthetic */ AmityStreamBroadcaster this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(long it) {
                    AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).startCamera();
                }
            }).subscribe();
        }
    }

    @Override
    public void stopPreview() {
        if (this.isCameraStart) {
            this.isCameraStart = false;
            new SingleTimer(300L, TimeUnit.MILLISECONDS, AndroidSchedulers.mainThread()).doOnSuccess(new Consumer(this){
                final /* synthetic */ AmityStreamBroadcaster this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(long it) {
                    AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).stopCamera();
                }
            }).subscribe();
        }
    }

    @Override
    public void startPublishNewStream(@NotNull String title, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        CreateVideoStreamingUC createVideoStreamingUC = new CreateVideoStreamingUC();
        AmityStreamBroadcasterConfiguration amityStreamBroadcasterConfiguration = this.configuration;
        if (amityStreamBroadcasterConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
            amityStreamBroadcasterConfiguration = null;
        }
        CreateVideoStreamingUC.execute$default(createVideoStreamingUC, title, description, amityStreamBroadcasterConfiguration.getResolution(), null, 8, null).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnSuccess(new Consumer(this){
            final /* synthetic */ AmityStreamBroadcaster this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull AmityBroadcasterData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityStreamBroadcaster.access$setBroadcasterData$p(this.this$0, it);
                AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).startPublish(it.getBroadcastingUrl());
            }
        }).subscribe();
    }

    @Override
    public void startPublish(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        new GetVideoStreamingUC().execute(streamId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnSuccess(new Consumer(this){
            final /* synthetic */ AmityStreamBroadcaster this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull PartialStreamData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityStreamBroadcaster.access$setBroadcasterData$p(this.this$0, new AmityBroadcasterData(it.getStreamId(), it.getBroadcastingUrl()));
                AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).startPublish(it.getBroadcastingUrl());
            }
        }).subscribe();
    }

    @Override
    public void switchCamera() {
        this.srsPublisher.switchCameraFace((this.srsPublisher.getCameraId() + 1) % Camera.getNumberOfCameras());
    }

    @Override
    public void stopPublish() {
        block0: {
            this.srsPublisher.stopPublish();
            AmityBroadcasterData amityBroadcasterData = this.broadcasterData;
            if (amityBroadcasterData == null) break block0;
            AmityBroadcasterData it = amityBroadcasterData;
            boolean bl = false;
            new DisposeVideoStreamingUC().execute(it.getStreamId()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe();
        }
    }

    @Override
    public void stopPublishWithNoInternet() {
        block0: {
            this.srsPublisher.stopPublishWhenNoInternet();
            AmityBroadcasterData amityBroadcasterData = this.broadcasterData;
            if (amityBroadcasterData == null) break block0;
            AmityBroadcasterData it = amityBroadcasterData;
            boolean bl = false;
            new DisposeVideoStreamingUC().execute(it.getStreamId()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe();
        }
    }

    @Override
    public void startAudio() {
        this.srsPublisher.startAudio();
    }

    @Override
    public void stopAudio() {
        this.srsPublisher.stopAudio();
    }

    @Override
    public void pausePublish() {
        this.isCameraStart = false;
        this.srsPublisher.stopPublish();
    }

    @Override
    public void resumePublish() {
        AmityBroadcasterData amityBroadcasterData = this.broadcasterData;
        Intrinsics.checkNotNull((Object)amityBroadcasterData);
        this.srsPublisher.startPublish(amityBroadcasterData.getBroadcastingUrl());
    }

    @Override
    @NotNull
    public Flowable<AmityStreamBroadcasterState> getStateFlowable() {
        Flowable flowable = this.srsPublisher.getStatusSubject().toFlowable(BackpressureStrategy.BUFFER);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"srsPublisher.statusSubje\u2026kpressureStrategy.BUFFER)");
        return flowable;
    }

    @Override
    public void updateConfiguration(@NotNull AmityStreamBroadcasterConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.srsPublisher.setOutputResolution(configuration.getResolution());
        this.srsPublisher.setVideoBitrate(configuration.getResolution());
        this.refreshCamera();
    }

    private final void refreshCamera() {
        new SingleTimer(300L, TimeUnit.MILLISECONDS, AndroidSchedulers.mainThread()).doOnSuccess(new Consumer(this){
            final /* synthetic */ AmityStreamBroadcaster this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(long it) {
                AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).switchCameraFace(AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).getCameraId());
            }
        }).subscribe();
    }

    public static final /* synthetic */ SrsPublisher access$getSrsPublisher$p(AmityStreamBroadcaster $this) {
        return $this.srsPublisher;
    }

    public static final /* synthetic */ void access$setBroadcasterData$p(AmityStreamBroadcaster $this, AmityBroadcasterData amityBroadcasterData) {
        $this.broadcasterData = amityBroadcasterData;
    }

    public /* synthetic */ AmityStreamBroadcaster(SrsPublisher srsPublisher, DefaultConstructorMarker $constructor_marker) {
        this(srsPublisher);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcaster$Builder;", "", "amityCameraView", "Lcom/amity/socialcloud/sdk/video/AmityCameraView;", "(Lcom/amity/socialcloud/sdk/video/AmityCameraView;)V", "configuration", "Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcasterConfiguration;", "statusSubject", "Lio/reactivex/rxjava3/subjects/PublishSubject;", "Lcom/amity/socialcloud/sdk/video/model/AmityStreamBroadcasterState;", "build", "Lcom/amity/socialcloud/sdk/video/StreamBroadcaster;", "setConfiguration", "amity-video-publisher_release"})
    @SourceDebugExtension(value={"SMAP\nAmityStreamBroadcaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmityStreamBroadcaster.kt\ncom/amity/socialcloud/sdk/video/AmityStreamBroadcaster$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
    public static final class Builder {
        @NotNull
        private final AmityCameraView amityCameraView;
        @NotNull
        private AmityStreamBroadcasterConfiguration configuration;
        @NotNull
        private PublishSubject<AmityStreamBroadcasterState> statusSubject;

        public Builder(@NotNull AmityCameraView amityCameraView) {
            Intrinsics.checkNotNullParameter((Object)((Object)amityCameraView), (String)"amityCameraView");
            this.amityCameraView = amityCameraView;
            this.configuration = new AmityStreamBroadcasterConfiguration.Builder().build();
            PublishSubject publishSubject = PublishSubject.create();
            Intrinsics.checkNotNullExpressionValue((Object)publishSubject, (String)"create()");
            this.statusSubject = publishSubject;
        }

        @NotNull
        public final Builder setConfiguration(@NotNull AmityStreamBroadcasterConfiguration configuration) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Builder $this$setConfiguration_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setConfiguration_u24lambda_u240.configuration = configuration;
            return builder;
        }

        @NotNull
        public final StreamBroadcaster build() {
            SrsPublisher publisher = new SrsPublisher(this.amityCameraView, this.statusSubject);
            publisher.setEncodeHandler(new SrsEncodeHandler(new DefaultEncodeHandlerListener()));
            publisher.setRecordHandler(new SrsRecordHandler(new DefaultRecordHandlerListener()));
            publisher.setPreviewResolution(this.configuration.getResolution());
            AmityStreamBroadcaster broadcaster = new AmityStreamBroadcaster(publisher, null);
            broadcaster.updateConfiguration(this.configuration);
            Context context = this.amityCameraView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"amityCameraView.context");
            EkoRtmpListener rtmpListener = new EkoRtmpListener(context, broadcaster, this.statusSubject);
            publisher.setRtmpHandler(new RtmpHandler(rtmpListener));
            return broadcaster;
        }
    }
}

