/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.base;

import android.opengl.GLES20;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import com.amity.seu.magicfilter.utils.OpenGLUtils;
import net.ossrs.yasea.R;

public class MagicLookupFilter
extends GPUImageFilter {
    protected String table;
    private int mLookupTextureUniform;
    private int mLookupSourceTexture = -1;

    public MagicLookupFilter(String table) {
        super(MagicFilterType.LOCKUP, R.raw.lookup);
        this.table = table;
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.mLookupTextureUniform = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputImageTexture2");
    }

    @Override
    protected void onInitialized() {
        super.onInitialized();
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                MagicLookupFilter.this.mLookupSourceTexture = OpenGLUtils.loadTexture(MagicLookupFilter.this.getContext(), MagicLookupFilter.this.table);
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        int[] texture = new int[]{this.mLookupSourceTexture};
        GLES20.glDeleteTextures((int)1, (int[])texture, (int)0);
        this.mLookupSourceTexture = -1;
    }

    @Override
    protected void onDrawArraysAfter() {
        if (this.mLookupSourceTexture != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glActiveTexture((int)33984);
        }
    }

    @Override
    protected void onDrawArraysPre() {
        if (this.mLookupSourceTexture != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)this.mLookupSourceTexture);
            GLES20.glUniform1i((int)this.mLookupTextureUniform, (int)3);
        }
    }
}

