/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp.packets;

import com.amity.github.faucamp.simplertmp.amf.AmfNumber;
import com.amity.github.faucamp.simplertmp.amf.AmfString;
import com.amity.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.amity.github.faucamp.simplertmp.packets.RtmpHeader;
import com.amity.github.faucamp.simplertmp.packets.VariableBodyRtmpPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Command
extends VariableBodyRtmpPacket {
    private static final String TAG = "Command";
    private String commandName;
    private int transactionId;

    public Command(RtmpHeader header) {
        super(header);
    }

    public Command(String commandName, int transactionId, ChunkStreamInfo channelInfo) {
        super(new RtmpHeader(channelInfo.canReusePrevHeaderTx(RtmpHeader.MessageType.COMMAND_AMF0) ? RtmpHeader.ChunkType.TYPE_1_RELATIVE_LARGE : RtmpHeader.ChunkType.TYPE_0_FULL, 3, RtmpHeader.MessageType.COMMAND_AMF0));
        this.commandName = commandName;
        this.transactionId = transactionId;
    }

    public Command(String commandName, int transactionId) {
        super(new RtmpHeader(RtmpHeader.ChunkType.TYPE_0_FULL, 3, RtmpHeader.MessageType.COMMAND_AMF0));
        this.commandName = commandName;
        this.transactionId = transactionId;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public void readBody(InputStream in) throws IOException {
        this.commandName = AmfString.readStringFrom(in, false);
        this.transactionId = (int)AmfNumber.readNumberFrom(in);
        int bytesRead = AmfString.sizeOf(this.commandName, false) + 9;
        this.readVariableData(in, bytesRead);
    }

    @Override
    protected void writeBody(OutputStream out) throws IOException {
        AmfString.writeStringTo(out, this.commandName, false);
        AmfNumber.writeNumberTo(out, this.transactionId);
        this.writeVariableData(out);
    }

    @Override
    protected byte[] array() {
        return null;
    }

    @Override
    protected int size() {
        return 0;
    }

    public String toString() {
        return "RTMP Command (command: " + this.commandName + ", transaction ID: " + this.transactionId + ")";
    }
}

