/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractBox;
import java.nio.ByteBuffer;

public class TrackReferenceTypeBox
extends AbstractBox {
    public static final String TYPE1 = "hint";
    public static final String TYPE2 = "cdsc";
    private long[] trackIds;

    public TrackReferenceTypeBox(String type) {
        super(type);
    }

    public long[] getTrackIds() {
        return this.trackIds;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        int count = content.remaining() / 4;
        this.trackIds = new long[count];
        for (int i = 0; i < count; ++i) {
            this.trackIds[i] = IsoTypeReader.readUInt32(content);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        for (long trackId : this.trackIds) {
            IsoTypeWriter.writeUInt32(byteBuffer, trackId);
        }
    }

    @Override
    protected long getContentSize() {
        return this.trackIds.length * 4;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TrackReferenceTypeBox[type=").append(this.getType());
        for (int i = 0; i < this.trackIds.length; ++i) {
            buffer.append(";trackId");
            buffer.append(i);
            buffer.append("=");
            buffer.append(this.trackIds[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

