/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso;

import com.amity.googlecode.mp4parser.util.CastUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;

public class ChannelHelper {
    public static ByteBuffer readFully(ReadableByteChannel channel, long size) throws IOException {
        if (channel instanceof FileChannel && size > 0x100000L) {
            MappedByteBuffer bb = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)channel).position(), size);
            ((FileChannel)channel).position(((FileChannel)channel).position() + size);
            return bb;
        }
        ByteBuffer buf = ByteBuffer.allocate(CastUtils.l2i(size));
        ChannelHelper.readFully(channel, buf, buf.limit());
        buf.rewind();
        assert ((long)buf.limit() == size);
        return buf;
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer buf) throws IOException {
        ChannelHelper.readFully(channel, buf, buf.remaining());
    }

    public static int readFully(ReadableByteChannel channel, ByteBuffer buf, int length) throws IOException {
        int n;
        int count = 0;
        while (-1 != (n = channel.read(buf)) && (count += n) != length) {
        }
        if (n == -1) {
            throw new EOFException("End of file. No more boxes.");
        }
        return count;
    }

    public static void writeFully(WritableByteChannel channel, ByteBuffer buf) throws IOException {
        do {
            int written;
            if ((written = channel.write(buf)) >= 0) continue;
            throw new EOFException();
        } while (buf.hasRemaining());
    }

    public static void close(SelectionKey key) {
        try {
            key.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

