/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.base.gpuimage;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.GLES20;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import com.amity.seu.magicfilter.utils.OpenGLUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import net.ossrs.yasea.R;

public class GPUImageFilter {
    private boolean mIsInitialized;
    private Context mContext;
    private MagicFilterType mType = MagicFilterType.NONE;
    private final LinkedList<Runnable> mRunOnDraw;
    private final int mVertexShaderId;
    private final int mFragmentShaderId;
    private int mGLProgId;
    private int mGLPositionIndex;
    private int mGLInputImageTextureIndex;
    private int mGLTextureCoordinateIndex;
    private int mGLTextureTransformIndex;
    protected int mInputWidth;
    protected int mInputHeight;
    protected int mOutputWidth;
    protected int mOutputHeight;
    protected FloatBuffer mGLCubeBuffer;
    protected FloatBuffer mGLTextureBuffer;
    private int[] mGLCubeId;
    private int[] mGLTextureCoordinateId;
    private float[] mGLTextureTransformMatrix;
    private int[] mGLFboId;
    private int[] mGLFboTexId;
    private IntBuffer mGLFboBuffer;

    public GPUImageFilter() {
        this(MagicFilterType.NONE);
    }

    public GPUImageFilter(MagicFilterType type) {
        this(type, R.raw.vertex, R.raw.fragment);
    }

    public GPUImageFilter(MagicFilterType type, int fragmentShaderId) {
        this(type, R.raw.vertex, fragmentShaderId);
    }

    public GPUImageFilter(MagicFilterType type, int vertexShaderId, int fragmentShaderId) {
        this.mType = type;
        this.mRunOnDraw = new LinkedList();
        this.mVertexShaderId = vertexShaderId;
        this.mFragmentShaderId = fragmentShaderId;
    }

    public void init(Context context) {
        this.mContext = context;
        this.onInit();
        this.onInitialized();
    }

    protected void onInit() {
        this.initVbo();
        this.loadSamplerShader();
    }

    protected void onInitialized() {
        this.mIsInitialized = true;
    }

    public final void destroy() {
        this.mIsInitialized = false;
        this.destroyFboTexture();
        this.destoryVbo();
        GLES20.glDeleteProgram((int)this.mGLProgId);
        this.onDestroy();
    }

    protected void onDestroy() {
    }

    public void onInputSizeChanged(int width, int height) {
        this.mInputWidth = width;
        this.mInputHeight = height;
        this.initFboTexture(width, height);
    }

    public void onDisplaySizeChanged(int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }

    private void loadSamplerShader() {
        this.mGLProgId = OpenGLUtils.loadProgram(OpenGLUtils.readShaderFromRawResource(this.getContext(), this.mVertexShaderId), OpenGLUtils.readShaderFromRawResource(this.getContext(), this.mFragmentShaderId));
        this.mGLPositionIndex = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"position");
        this.mGLTextureCoordinateIndex = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"inputTextureCoordinate");
        this.mGLTextureTransformIndex = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"textureTransform");
        this.mGLInputImageTextureIndex = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"inputImageTexture");
    }

    private void initVbo() {
        float[] VEX_CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        float[] TEX_COORD = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        this.mGLCubeBuffer = ByteBuffer.allocateDirect(VEX_CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLCubeBuffer.put(VEX_CUBE).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TEX_COORD.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureBuffer.put(TEX_COORD).position(0);
        this.mGLCubeId = new int[1];
        this.mGLTextureCoordinateId = new int[1];
        GLES20.glGenBuffers((int)1, (int[])this.mGLCubeId, (int)0);
        GLES20.glBindBuffer((int)34962, (int)this.mGLCubeId[0]);
        GLES20.glBufferData((int)34962, (int)(this.mGLCubeBuffer.capacity() * 4), (Buffer)this.mGLCubeBuffer, (int)35044);
        GLES20.glGenBuffers((int)1, (int[])this.mGLTextureCoordinateId, (int)0);
        GLES20.glBindBuffer((int)34962, (int)this.mGLTextureCoordinateId[0]);
        GLES20.glBufferData((int)34962, (int)(this.mGLTextureBuffer.capacity() * 4), (Buffer)this.mGLTextureBuffer, (int)35044);
    }

    private void destoryVbo() {
        if (this.mGLCubeId != null) {
            GLES20.glDeleteBuffers((int)1, (int[])this.mGLCubeId, (int)0);
            this.mGLCubeId = null;
        }
        if (this.mGLTextureCoordinateId != null) {
            GLES20.glDeleteBuffers((int)1, (int[])this.mGLTextureCoordinateId, (int)0);
            this.mGLTextureCoordinateId = null;
        }
    }

    private void initFboTexture(int width, int height) {
        if (this.mGLFboId != null && (this.mInputWidth != width || this.mInputHeight != height)) {
            this.destroyFboTexture();
        }
        this.mGLFboId = new int[1];
        this.mGLFboTexId = new int[1];
        this.mGLFboBuffer = IntBuffer.allocate(width * height);
        GLES20.glGenFramebuffers((int)1, (int[])this.mGLFboId, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.mGLFboTexId, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.mGLFboTexId[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glBindFramebuffer((int)36160, (int)this.mGLFboId[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mGLFboTexId[0], (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private void destroyFboTexture() {
        if (this.mGLFboTexId != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.mGLFboTexId, (int)0);
            this.mGLFboTexId = null;
        }
        if (this.mGLFboId != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.mGLFboId, (int)0);
            this.mGLFboId = null;
        }
    }

    public int onDrawFrame(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        if (!this.mIsInitialized) {
            return -1;
        }
        GLES20.glUseProgram((int)this.mGLProgId);
        this.runPendingOnDrawTasks();
        GLES20.glEnableVertexAttribArray((int)this.mGLPositionIndex);
        GLES20.glVertexAttribPointer((int)this.mGLPositionIndex, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)cubeBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLTextureCoordinateIndex);
        GLES20.glVertexAttribPointer((int)this.mGLTextureCoordinateIndex, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)textureBuffer);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            GLES20.glUniform1i((int)this.mGLInputImageTextureIndex, (int)0);
        }
        this.onDrawArraysPre();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.onDrawArraysAfter();
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glDisableVertexAttribArray((int)this.mGLPositionIndex);
        GLES20.glDisableVertexAttribArray((int)this.mGLTextureCoordinateIndex);
        return 1;
    }

    public int onDrawFrame(int cameraTextureId) {
        if (!this.mIsInitialized) {
            return -1;
        }
        if (this.mGLFboId == null) {
            return -1;
        }
        GLES20.glUseProgram((int)this.mGLProgId);
        this.runPendingOnDrawTasks();
        GLES20.glBindBuffer((int)34962, (int)this.mGLCubeId[0]);
        GLES20.glEnableVertexAttribArray((int)this.mGLPositionIndex);
        GLES20.glVertexAttribPointer((int)this.mGLPositionIndex, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glBindBuffer((int)34962, (int)this.mGLTextureCoordinateId[0]);
        GLES20.glEnableVertexAttribArray((int)this.mGLTextureCoordinateIndex);
        GLES20.glVertexAttribPointer((int)this.mGLTextureCoordinateIndex, (int)2, (int)5126, (boolean)false, (int)8, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mGLTextureTransformIndex, (int)1, (boolean)false, (float[])this.mGLTextureTransformMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)cameraTextureId);
        GLES20.glUniform1i((int)this.mGLInputImageTextureIndex, (int)0);
        this.onDrawArraysPre();
        GLES20.glViewport((int)0, (int)0, (int)this.mInputWidth, (int)this.mInputHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.mGLFboId[0]);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glReadPixels((int)0, (int)0, (int)this.mInputWidth, (int)this.mInputHeight, (int)6408, (int)5121, (Buffer)this.mGLFboBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.onDrawArraysAfter();
        GLES20.glBindTexture((int)36197, (int)0);
        GLES20.glDisableVertexAttribArray((int)this.mGLPositionIndex);
        GLES20.glDisableVertexAttribArray((int)this.mGLTextureCoordinateIndex);
        GLES20.glBindBuffer((int)34962, (int)0);
        return this.mGLFboTexId[0];
    }

    protected void onDrawArraysPre() {
    }

    protected void onDrawArraysAfter() {
    }

    private void runPendingOnDrawTasks() {
        while (!this.mRunOnDraw.isEmpty()) {
            this.mRunOnDraw.removeFirst().run();
        }
    }

    public int getProgram() {
        return this.mGLProgId;
    }

    public IntBuffer getGLFboBuffer() {
        return this.mGLFboBuffer;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected MagicFilterType getFilterType() {
        return this.mType;
    }

    public void setTextureTransformMatrix(float[] mtx) {
        this.mGLTextureTransformMatrix = mtx;
    }

    protected void setInteger(final int location, final int intValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1i((int)location, (int)intValue);
            }
        });
    }

    protected void setFloat(final int location, final float floatValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)location, (float)floatValue);
            }
        });
    }

    protected void setFloatVec2(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform2fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec3(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec4(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatArray(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1fv((int)location, (int)arrayValue.length, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setPoint(final int location, final PointF point) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                float[] vec2 = new float[]{point.x, point.y};
                GLES20.glUniform2fv((int)location, (int)1, (float[])vec2, (int)0);
            }
        });
    }

    protected void setUniformMatrix3f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix3fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    protected void setUniformMatrix4f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.mRunOnDraw;
        synchronized (linkedList) {
            this.mRunOnDraw.addLast(runnable);
        }
    }
}

