/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.boxes;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractBox;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import java.nio.ByteBuffer;

public class DTSSpecificBox
extends AbstractBox {
    long DTSSamplingFrequency;
    long maxBitRate;
    long avgBitRate;
    int pcmSampleDepth;
    int frameDuration;
    int streamConstruction;
    int coreLFEPresent;
    int coreLayout;
    int coreSize;
    int stereoDownmix;
    int representationType;
    int channelLayout;
    int multiAssetFlag;
    int LBRDurationMod;
    int reservedBoxPresent;
    int reserved;

    public DTSSpecificBox() {
        super("ddts");
    }

    @Override
    protected long getContentSize() {
        return 20L;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.DTSSamplingFrequency = IsoTypeReader.readUInt32(content);
        this.maxBitRate = IsoTypeReader.readUInt32(content);
        this.avgBitRate = IsoTypeReader.readUInt32(content);
        this.pcmSampleDepth = IsoTypeReader.readUInt8(content);
        BitReaderBuffer brb = new BitReaderBuffer(content);
        this.frameDuration = brb.readBits(2);
        this.streamConstruction = brb.readBits(5);
        this.coreLFEPresent = brb.readBits(1);
        this.coreLayout = brb.readBits(6);
        this.coreSize = brb.readBits(14);
        this.stereoDownmix = brb.readBits(1);
        this.representationType = brb.readBits(3);
        this.channelLayout = brb.readBits(16);
        this.multiAssetFlag = brb.readBits(1);
        this.LBRDurationMod = brb.readBits(1);
        this.reservedBoxPresent = brb.readBits(1);
        this.reserved = brb.readBits(5);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt32(byteBuffer, this.DTSSamplingFrequency);
        IsoTypeWriter.writeUInt32(byteBuffer, this.maxBitRate);
        IsoTypeWriter.writeUInt32(byteBuffer, this.avgBitRate);
        IsoTypeWriter.writeUInt8(byteBuffer, this.pcmSampleDepth);
        BitWriterBuffer bwb = new BitWriterBuffer(byteBuffer);
        bwb.writeBits(this.frameDuration, 2);
        bwb.writeBits(this.streamConstruction, 5);
        bwb.writeBits(this.coreLFEPresent, 1);
        bwb.writeBits(this.coreLayout, 6);
        bwb.writeBits(this.coreSize, 14);
        bwb.writeBits(this.stereoDownmix, 1);
        bwb.writeBits(this.representationType, 3);
        bwb.writeBits(this.channelLayout, 16);
        bwb.writeBits(this.multiAssetFlag, 1);
        bwb.writeBits(this.LBRDurationMod, 1);
        bwb.writeBits(this.reservedBoxPresent, 1);
        bwb.writeBits(this.reserved, 5);
    }

    public long getAvgBitRate() {
        return this.avgBitRate;
    }

    public void setAvgBitRate(long avgBitRate) {
        this.avgBitRate = avgBitRate;
    }

    public long getDTSSamplingFrequency() {
        return this.DTSSamplingFrequency;
    }

    public void setDTSSamplingFrequency(long DTSSamplingFrequency) {
        this.DTSSamplingFrequency = DTSSamplingFrequency;
    }

    public long getMaxBitRate() {
        return this.maxBitRate;
    }

    public void setMaxBitRate(long maxBitRate) {
        this.maxBitRate = maxBitRate;
    }

    public int getPcmSampleDepth() {
        return this.pcmSampleDepth;
    }

    public void setPcmSampleDepth(int pcmSampleDepth) {
        this.pcmSampleDepth = pcmSampleDepth;
    }

    public int getFrameDuration() {
        return this.frameDuration;
    }

    public void setFrameDuration(int frameDuration) {
        this.frameDuration = frameDuration;
    }

    public int getStreamConstruction() {
        return this.streamConstruction;
    }

    public void setStreamConstruction(int streamConstruction) {
        this.streamConstruction = streamConstruction;
    }

    public int getCoreLFEPresent() {
        return this.coreLFEPresent;
    }

    public void setCoreLFEPresent(int coreLFEPresent) {
        this.coreLFEPresent = coreLFEPresent;
    }

    public int getCoreLayout() {
        return this.coreLayout;
    }

    public void setCoreLayout(int coreLayout) {
        this.coreLayout = coreLayout;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public int getStereoDownmix() {
        return this.stereoDownmix;
    }

    public void setStereoDownmix(int stereoDownmix) {
        this.stereoDownmix = stereoDownmix;
    }

    public int getRepresentationType() {
        return this.representationType;
    }

    public void setRepresentationType(int representationType) {
        this.representationType = representationType;
    }

    public int getChannelLayout() {
        return this.channelLayout;
    }

    public void setChannelLayout(int channelLayout) {
        this.channelLayout = channelLayout;
    }

    public int getMultiAssetFlag() {
        return this.multiAssetFlag;
    }

    public void setMultiAssetFlag(int multiAssetFlag) {
        this.multiAssetFlag = multiAssetFlag;
    }

    public int getLBRDurationMod() {
        return this.LBRDurationMod;
    }

    public void setLBRDurationMod(int LBRDurationMod) {
        this.LBRDurationMod = LBRDurationMod;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public int getReservedBoxPresent() {
        return this.reservedBoxPresent;
    }

    public void setReservedBoxPresent(int reservedBoxPresent) {
        this.reservedBoxPresent = reservedBoxPresent;
    }
}

