/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.authoring.tracks;

import com.amity.coremedia.iso.boxes.Box;
import com.amity.coremedia.iso.boxes.CompositionTimeToSample;
import com.amity.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.amity.coremedia.iso.boxes.SampleDescriptionBox;
import com.amity.coremedia.iso.boxes.SubSampleInformationBox;
import com.amity.coremedia.iso.boxes.TimeToSampleBox;
import com.amity.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.amity.googlecode.mp4parser.authoring.AbstractTrack;
import com.amity.googlecode.mp4parser.authoring.Track;
import com.amity.googlecode.mp4parser.authoring.TrackMetaData;
import com.amity.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.amity.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AppendTrack
extends AbstractTrack {
    Track[] tracks;
    SampleDescriptionBox stsd;

    public AppendTrack(Track ... tracks) throws IOException {
        this.tracks = tracks;
        for (Track track : tracks) {
            AudioSampleEntry aseResult;
            if (this.stsd == null) {
                this.stsd = track.getSampleDescriptionBox();
                continue;
            }
            ByteArrayOutputStream curBaos = new ByteArrayOutputStream();
            ByteArrayOutputStream refBaos = new ByteArrayOutputStream();
            track.getSampleDescriptionBox().getBox(Channels.newChannel(curBaos));
            this.stsd.getBox(Channels.newChannel(refBaos));
            byte[] cur = curBaos.toByteArray();
            byte[] ref = refBaos.toByteArray();
            if (Arrays.equals(ref, cur)) continue;
            SampleDescriptionBox curStsd = track.getSampleDescriptionBox();
            if (this.stsd.getBoxes().size() == 1 && curStsd.getBoxes().size() == 1 && this.stsd.getBoxes().get(0) instanceof AudioSampleEntry && curStsd.getBoxes().get(0) instanceof AudioSampleEntry && (aseResult = this.mergeAudioSampleEntries((AudioSampleEntry)this.stsd.getBoxes().get(0), (AudioSampleEntry)curStsd.getBoxes().get(0))) != null) {
                this.stsd.setBoxes(Collections.singletonList(aseResult));
                return;
            }
            throw new IOException("Cannot append " + track + " to " + tracks[0] + " since their Sample Description Boxes differ: \n" + track.getSampleDescriptionBox() + "\n vs. \n" + tracks[0].getSampleDescriptionBox());
        }
    }

    private AudioSampleEntry mergeAudioSampleEntries(AudioSampleEntry ase1, AudioSampleEntry ase2) throws IOException {
        if (ase1.getType().equals(ase2.getType())) {
            AudioSampleEntry ase = new AudioSampleEntry(ase2.getType());
            if (ase1.getBytesPerFrame() != ase2.getBytesPerFrame()) {
                return null;
            }
            ase.setBytesPerFrame(ase1.getBytesPerFrame());
            if (ase1.getBytesPerPacket() != ase2.getBytesPerPacket()) {
                return null;
            }
            ase.setBytesPerPacket(ase1.getBytesPerPacket());
            if (ase1.getBytesPerSample() != ase2.getBytesPerSample()) {
                return null;
            }
            ase.setBytesPerSample(ase1.getBytesPerSample());
            if (ase1.getChannelCount() != ase2.getChannelCount()) {
                return null;
            }
            ase.setChannelCount(ase1.getChannelCount());
            if (ase1.getPacketSize() != ase2.getPacketSize()) {
                return null;
            }
            ase.setPacketSize(ase1.getPacketSize());
            if (ase1.getCompressionId() != ase2.getCompressionId()) {
                return null;
            }
            ase.setCompressionId(ase1.getCompressionId());
            if (ase1.getSampleRate() != ase2.getSampleRate()) {
                return null;
            }
            ase.setSampleRate(ase1.getSampleRate());
            if (ase1.getSampleSize() != ase2.getSampleSize()) {
                return null;
            }
            ase.setSampleSize(ase1.getSampleSize());
            if (ase1.getSamplesPerPacket() != ase2.getSamplesPerPacket()) {
                return null;
            }
            ase.setSamplesPerPacket(ase1.getSamplesPerPacket());
            if (ase1.getSoundVersion() != ase2.getSoundVersion()) {
                return null;
            }
            ase.setSoundVersion(ase1.getSoundVersion());
            if (!Arrays.equals(ase1.getSoundVersion2Data(), ase2.getSoundVersion2Data())) {
                return null;
            }
            ase.setSoundVersion2Data(ase1.getSoundVersion2Data());
            if (ase1.getBoxes().size() == ase2.getBoxes().size()) {
                Iterator<Box> bxs1 = ase1.getBoxes().iterator();
                Iterator<Box> bxs2 = ase2.getBoxes().iterator();
                while (bxs1.hasNext()) {
                    Box cur1 = bxs1.next();
                    Box cur2 = bxs2.next();
                    ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    cur1.getBox(Channels.newChannel(baos1));
                    cur2.getBox(Channels.newChannel(baos2));
                    if (Arrays.equals(baos1.toByteArray(), baos2.toByteArray())) {
                        ase.addBox(cur1);
                        continue;
                    }
                    if (!"esds".equals(cur1.getType()) || !"esds".equals(cur2.getType())) continue;
                    ESDescriptorBox esdsBox1 = (ESDescriptorBox)cur1;
                    ESDescriptorBox esdsBox2 = (ESDescriptorBox)cur2;
                    ESDescriptor esds1 = esdsBox1.getEsDescriptor();
                    ESDescriptor esds2 = esdsBox2.getEsDescriptor();
                    if (esds1.getURLFlag() != esds2.getURLFlag()) {
                        return null;
                    }
                    if (esds1.getURLLength() != esds2.getURLLength()) {
                        return null;
                    }
                    if (esds1.getDependsOnEsId() != esds2.getDependsOnEsId()) {
                        return null;
                    }
                    if (esds1.getEsId() != esds2.getEsId()) {
                        return null;
                    }
                    if (esds1.getoCREsId() != esds2.getoCREsId()) {
                        return null;
                    }
                    if (esds1.getoCRstreamFlag() != esds2.getoCRstreamFlag()) {
                        return null;
                    }
                    if (esds1.getRemoteODFlag() != esds2.getRemoteODFlag()) {
                        return null;
                    }
                    if (esds1.getStreamDependenceFlag() != esds2.getStreamDependenceFlag()) {
                        return null;
                    }
                    if (esds1.getStreamPriority() != esds2.getStreamPriority()) {
                        return null;
                    }
                    if (esds1.getURLString() != null ? !esds1.getURLString().equals(esds2.getURLString()) : esds2.getURLString() != null) {
                        return null;
                    }
                    if (esds1.getDecoderConfigDescriptor() != null ? !esds1.getDecoderConfigDescriptor().equals(esds2.getDecoderConfigDescriptor()) : esds2.getDecoderConfigDescriptor() != null) {
                        DecoderConfigDescriptor dcd1 = esds1.getDecoderConfigDescriptor();
                        DecoderConfigDescriptor dcd2 = esds2.getDecoderConfigDescriptor();
                        if (!dcd1.getAudioSpecificInfo().equals(dcd2.getAudioSpecificInfo())) {
                            return null;
                        }
                        if (dcd1.getAvgBitRate() != dcd2.getAvgBitRate()) {
                            // empty if block
                        }
                        if (dcd1.getBufferSizeDB() != dcd2.getBufferSizeDB()) {
                            // empty if block
                        }
                        if (dcd1.getDecoderSpecificInfo() != null ? !dcd1.getDecoderSpecificInfo().equals(dcd2.getDecoderSpecificInfo()) : dcd2.getDecoderSpecificInfo() != null) {
                            return null;
                        }
                        if (dcd1.getMaxBitRate() != dcd2.getMaxBitRate()) {
                            // empty if block
                        }
                        if (!dcd1.getProfileLevelIndicationDescriptors().equals(dcd2.getProfileLevelIndicationDescriptors())) {
                            return null;
                        }
                        if (dcd1.getObjectTypeIndication() != dcd2.getObjectTypeIndication()) {
                            return null;
                        }
                        if (dcd1.getStreamType() != dcd2.getStreamType()) {
                            return null;
                        }
                        if (dcd1.getUpStream() != dcd2.getUpStream()) {
                            return null;
                        }
                    }
                    if (esds1.getOtherDescriptors() != null ? !esds1.getOtherDescriptors().equals(esds2.getOtherDescriptors()) : esds2.getOtherDescriptors() != null) {
                        return null;
                    }
                    if (esds1.getSlConfigDescriptor() != null ? !esds1.getSlConfigDescriptor().equals(esds2.getSlConfigDescriptor()) : esds2.getSlConfigDescriptor() != null) {
                        return null;
                    }
                    ase.addBox(cur1);
                }
            }
            return ase;
        }
        return null;
    }

    @Override
    public List<ByteBuffer> getSamples() {
        ArrayList<ByteBuffer> lists = new ArrayList<ByteBuffer>();
        for (Track track : this.tracks) {
            lists.addAll(track.getSamples());
        }
        return lists;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.tracks[0].getDecodingTimeEntries() != null && !this.tracks[0].getDecodingTimeEntries().isEmpty()) {
            LinkedList<long[]> lists = new LinkedList<long[]>();
            for (Track track : this.tracks) {
                lists.add(TimeToSampleBox.blowupTimeToSamples(track.getDecodingTimeEntries()));
            }
            LinkedList<TimeToSampleBox.Entry> returnDecodingEntries = new LinkedList<TimeToSampleBox.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                long[] list;
                for (long nuDecodingTime : list = (long[])iterator.next()) {
                    TimeToSampleBox.Entry e;
                    if (returnDecodingEntries.isEmpty() || returnDecodingEntries.getLast().getDelta() != nuDecodingTime) {
                        e = new TimeToSampleBox.Entry(1L, nuDecodingTime);
                        returnDecodingEntries.add(e);
                        continue;
                    }
                    e = returnDecodingEntries.getLast();
                    e.setCount(e.getCount() + 1L);
                }
            }
            return returnDecodingEntries;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> lists = new LinkedList<int[]>();
            for (Track track : this.tracks) {
                lists.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
            }
            LinkedList<CompositionTimeToSample.Entry> compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            Iterator iterator = lists.iterator();
            while (iterator.hasNext()) {
                int[] list;
                for (int compositionTime : list = (int[])iterator.next()) {
                    CompositionTimeToSample.Entry e;
                    if (compositionTimeEntries.isEmpty() || compositionTimeEntries.getLast().getOffset() != compositionTime) {
                        e = new CompositionTimeToSample.Entry(1, compositionTime);
                        compositionTimeEntries.add(e);
                        continue;
                    }
                    e = compositionTimeEntries.getLast();
                    e.setCount(e.getCount() + 1);
                }
            }
            return compositionTimeEntries;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int numSyncSamples = 0;
            for (Track track : this.tracks) {
                numSyncSamples += track.getSyncSamples().length;
            }
            long[] returnSyncSamples = new long[numSyncSamples];
            int pos = 0;
            long samplesBefore = 0L;
            for (Track track : this.tracks) {
                for (long l : track.getSyncSamples()) {
                    returnSyncSamples[pos++] = samplesBefore + l;
                }
                samplesBefore += (long)track.getSamples().size();
            }
            return returnSyncSamples;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> list = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (Track track : this.tracks) {
                list.addAll(track.getSampleDependencies());
            }
            return list;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.tracks[0].getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.tracks[0].getSubsampleInformationBox();
    }
}

