/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp.packets;

import com.amity.github.faucamp.simplertmp.amf.AmfBoolean;
import com.amity.github.faucamp.simplertmp.amf.AmfData;
import com.amity.github.faucamp.simplertmp.amf.AmfDecoder;
import com.amity.github.faucamp.simplertmp.amf.AmfNull;
import com.amity.github.faucamp.simplertmp.amf.AmfNumber;
import com.amity.github.faucamp.simplertmp.amf.AmfString;
import com.amity.github.faucamp.simplertmp.packets.RtmpHeader;
import com.amity.github.faucamp.simplertmp.packets.RtmpPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class VariableBodyRtmpPacket
extends RtmpPacket {
    protected List<AmfData> data;

    public VariableBodyRtmpPacket(RtmpHeader header) {
        super(header);
    }

    public List<AmfData> getData() {
        return this.data;
    }

    public void addData(String string) {
        this.addData(new AmfString(string));
    }

    public void addData(double number) {
        this.addData(new AmfNumber(number));
    }

    public void addData(boolean bool) {
        this.addData(new AmfBoolean(bool));
    }

    public void addData(AmfData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<AmfData>();
        }
        if (dataItem == null) {
            dataItem = new AmfNull();
        }
        this.data.add(dataItem);
    }

    protected void readVariableData(InputStream in, int bytesAlreadyRead) throws IOException {
        AmfData dataItem;
        do {
            dataItem = AmfDecoder.readFrom(in);
            this.addData(dataItem);
        } while ((bytesAlreadyRead += dataItem.getSize()) < this.header.getPacketLength());
    }

    protected void writeVariableData(OutputStream out) throws IOException {
        if (this.data != null) {
            for (AmfData dataItem : this.data) {
                dataItem.writeTo(out);
            }
        } else {
            AmfNull.writeNullTo(out);
        }
    }
}

