/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp.io;

import com.amity.github.faucamp.simplertmp.RtmpHandler;
import com.amity.github.faucamp.simplertmp.RtmpPublisher;
import com.amity.github.faucamp.simplertmp.amf.AmfMap;
import com.amity.github.faucamp.simplertmp.amf.AmfNull;
import com.amity.github.faucamp.simplertmp.amf.AmfNumber;
import com.amity.github.faucamp.simplertmp.amf.AmfObject;
import com.amity.github.faucamp.simplertmp.amf.AmfString;
import com.amity.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.amity.github.faucamp.simplertmp.io.RtmpDecoder;
import com.amity.github.faucamp.simplertmp.io.RtmpSessionInfo;
import com.amity.github.faucamp.simplertmp.packets.Abort;
import com.amity.github.faucamp.simplertmp.packets.Audio;
import com.amity.github.faucamp.simplertmp.packets.Command;
import com.amity.github.faucamp.simplertmp.packets.Data;
import com.amity.github.faucamp.simplertmp.packets.Handshake;
import com.amity.github.faucamp.simplertmp.packets.RtmpPacket;
import com.amity.github.faucamp.simplertmp.packets.SetPeerBandwidth;
import com.amity.github.faucamp.simplertmp.packets.UserControl;
import com.amity.github.faucamp.simplertmp.packets.Video;
import com.amity.github.faucamp.simplertmp.packets.WindowAckSize;
import com.amity.socialcloud.sdk.log.AmityLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RtmpConnection
implements RtmpPublisher {
    private static final String TAG = "RtmpConnection";
    private static final Pattern rtmpUrlPattern = Pattern.compile("^rtmp://([^/:]+)(:(\\d+))*/([^/]+)(/(.*))*$");
    private RtmpHandler mHandler;
    private int port;
    private String host;
    private String appName;
    private String streamName;
    private String publishType;
    private String swfUrl;
    private String tcUrl;
    private String pageUrl;
    private Socket socket;
    private String srsServerInfo = "";
    private String socketExceptionCause = "";
    private RtmpSessionInfo rtmpSessionInfo;
    private RtmpDecoder rtmpDecoder;
    private BufferedInputStream inputStream;
    private BufferedOutputStream outputStream;
    private Thread rxPacketHandler;
    private volatile boolean connected = false;
    private volatile boolean publishPermitted = false;
    private final Object connectingLock = new Object();
    private final Object publishLock = new Object();
    private AtomicInteger videoFrameCacheNumber = new AtomicInteger(0);
    private int currentStreamId = 0;
    private int transactionIdCounter = 0;
    private AmfString serverIpAddr;
    private AmfNumber serverPid;
    private AmfNumber serverId;
    private int videoWidth;
    private int videoHeight;
    private int videoFrameCount;
    private int videoDataLength;
    private int audioFrameCount;
    private int audioDataLength;
    private long videoLastTimeMillis;
    private long audioLastTimeMillis;

    public RtmpConnection(RtmpHandler handler) {
        this.mHandler = handler;
    }

    private void handshake(InputStream in, OutputStream out) throws IOException {
        Handshake handshake = new Handshake();
        handshake.writeC0(out);
        handshake.writeC1(out);
        out.flush();
        handshake.readS0(in);
        handshake.readS1(in);
        handshake.writeC2(out);
        out.flush();
        handshake.readS2(in);
    }

    @Override
    public boolean connect(String url) {
        Matcher matcher = rtmpUrlPattern.matcher(url);
        if (!matcher.matches()) {
            this.mHandler.notifyRtmpIllegalArgumentException(new IllegalArgumentException("Invalid RTMP URL. Must be in format: rtmp://host[:port]/application/streamName"));
            return false;
        }
        this.tcUrl = url.substring(0, url.lastIndexOf(47));
        this.swfUrl = "";
        this.pageUrl = "";
        this.host = matcher.group(1);
        String portStr = matcher.group(3);
        this.port = portStr != null ? Integer.parseInt(portStr) : 1935;
        this.appName = matcher.group(4);
        this.streamName = matcher.group(6);
        if (this.streamName == null || this.appName == null) {
            this.mHandler.notifyRtmpIllegalArgumentException(new IllegalArgumentException("Invalid RTMP URL. Must be in format: rtmp://host[:port]/application/streamName"));
            return false;
        }
        AmityLog.INSTANCE.tag(TAG).d("connect() called. Host: " + this.host + ", port: " + this.port + ", appName: " + this.appName + ", publishPath: " + this.streamName, new Object[0]);
        this.rtmpSessionInfo = new RtmpSessionInfo();
        this.rtmpDecoder = new RtmpDecoder(this.rtmpSessionInfo);
        this.socket = new Socket();
        InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
        try {
            if (this.socket != null) {
                this.socket.connect(socketAddress, 3000);
                this.inputStream = new BufferedInputStream(this.socket.getInputStream());
                this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
                AmityLog.INSTANCE.tag(TAG).d("connect(): socket connection established, doing handhake...", new Object[0]);
                this.handshake(this.inputStream, this.outputStream);
                AmityLog.INSTANCE.tag(TAG).d("connect(): handshake done", new Object[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mHandler.notifyRtmpIOException(e);
            return false;
        }
        this.rxPacketHandler = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AmityLog.INSTANCE.tag(RtmpConnection.TAG).d("starting main rx handler loop", new Object[0]);
                    RtmpConnection.this.handleRxPacketLoop();
                }
                catch (IOException ex) {
                    Logger.getLogger(RtmpConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.rxPacketHandler.start();
        return this.rtmpConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rtmpConnect() {
        if (this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Already connected to RTMP server"));
            return false;
        }
        ChunkStreamInfo.markSessionTimestampTx();
        AmityLog.INSTANCE.tag(TAG).d("rtmpConnect(): Building 'connect' invoke packet", new Object[0]);
        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(3);
        Command invoke = new Command("connect", ++this.transactionIdCounter, chunkStreamInfo);
        invoke.getHeader().setMessageStreamId(0);
        AmfObject args = new AmfObject();
        args.setProperty("app", this.appName);
        args.setProperty("flashVer", "LNX 11,2,202,233");
        args.setProperty("swfUrl", this.swfUrl);
        args.setProperty("tcUrl", this.tcUrl);
        args.setProperty("fpad", false);
        args.setProperty("capabilities", 239);
        args.setProperty("audioCodecs", 3575);
        args.setProperty("videoCodecs", 252);
        args.setProperty("videoFunction", 1);
        args.setProperty("pageUrl", this.pageUrl);
        args.setProperty("objectEncoding", 0);
        invoke.addData(args);
        this.sendRtmpPacket(invoke);
        this.mHandler.notifyRtmpConnecting("Connecting");
        Object object = this.connectingLock;
        synchronized (object) {
            try {
                this.connectingLock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.connected) {
            this.shutdown();
        }
        return this.connected;
    }

    @Override
    public boolean publish(String type) {
        if (type == null) {
            this.mHandler.notifyRtmpIllegalArgumentException(new IllegalArgumentException("No publish type specified"));
            return false;
        }
        this.publishType = type;
        return this.createStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createStream() {
        if (!this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not connected to RTMP server"));
            return false;
        }
        if (this.currentStreamId != 0) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Current stream object has existed"));
            return false;
        }
        AmityLog.INSTANCE.tag(TAG).d("createStream(): Sending releaseStream command...", new Object[0]);
        Command releaseStream = new Command("releaseStream", ++this.transactionIdCounter);
        releaseStream.getHeader().setChunkStreamId(5);
        releaseStream.addData(new AmfNull());
        releaseStream.addData(this.streamName);
        this.sendRtmpPacket(releaseStream);
        AmityLog.INSTANCE.tag(TAG).d("createStream(): Sending FCPublish command...", new Object[0]);
        Command FCPublish = new Command("FCPublish", ++this.transactionIdCounter);
        FCPublish.getHeader().setChunkStreamId(5);
        FCPublish.addData(new AmfNull());
        FCPublish.addData(this.streamName);
        this.sendRtmpPacket(FCPublish);
        AmityLog.INSTANCE.tag(TAG).d("createStream(): Sending createStream command...", new Object[0]);
        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(3);
        Command createStream = new Command("createStream", ++this.transactionIdCounter, chunkStreamInfo);
        createStream.addData(new AmfNull());
        this.sendRtmpPacket(createStream);
        Object object = this.publishLock;
        synchronized (object) {
            try {
                this.publishLock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.publishPermitted) {
            this.mHandler.notifyRtmpConnected("Connected" + this.srsServerInfo);
        } else {
            this.shutdown();
        }
        return this.publishPermitted;
    }

    private void fmlePublish() {
        if (!this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not connected to RTMP server"));
            return;
        }
        if (this.currentStreamId == 0) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("No current stream object exists"));
            return;
        }
        AmityLog.INSTANCE.tag(TAG).d("fmlePublish(): Sending publish command...", new Object[0]);
        Command publish = new Command("publish", 0);
        publish.getHeader().setChunkStreamId(5);
        publish.getHeader().setMessageStreamId(this.currentStreamId);
        publish.addData(new AmfNull());
        publish.addData(this.streamName);
        publish.addData(this.publishType);
        this.sendRtmpPacket(publish);
    }

    private void onMetaData() {
        if (!this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not connected to RTMP server"));
            return;
        }
        if (this.currentStreamId == 0) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("No current stream object exists"));
            return;
        }
        AmityLog.INSTANCE.tag(TAG).d("onMetaData(): Sending empty onMetaData...", new Object[0]);
        Data metadata = new Data("@setDataFrame");
        metadata.getHeader().setMessageStreamId(this.currentStreamId);
        metadata.addData("onMetaData");
        AmfMap ecmaArray = new AmfMap();
        ecmaArray.setProperty("duration", 0);
        ecmaArray.setProperty("width", this.videoWidth);
        ecmaArray.setProperty("height", this.videoHeight);
        ecmaArray.setProperty("videodatarate", 0);
        ecmaArray.setProperty("framerate", 0);
        ecmaArray.setProperty("audiodatarate", 0);
        ecmaArray.setProperty("audiosamplerate", 44100);
        ecmaArray.setProperty("audiosamplesize", 16);
        ecmaArray.setProperty("stereo", true);
        ecmaArray.setProperty("filesize", 0);
        metadata.addData(ecmaArray);
        this.sendRtmpPacket(metadata);
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.closeStream();
        }
        this.shutdown();
    }

    private void closeStream() {
        if (!this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not connected to RTMP server"));
            return;
        }
        if (this.currentStreamId == 0) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("No current stream object exists"));
            return;
        }
        if (!this.publishPermitted) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not get _result(Netstream.Publish.Start)"));
            return;
        }
        AmityLog.INSTANCE.tag(TAG).d("closeStream(): setting current stream ID to 0", new Object[0]);
        Command closeStream = new Command("closeStream", 0);
        closeStream.getHeader().setChunkStreamId(5);
        closeStream.getHeader().setMessageStreamId(this.currentStreamId);
        closeStream.addData(new AmfNull());
        this.sendRtmpPacket(closeStream);
        this.mHandler.notifyRtmpStopped();
    }

    private void shutdown() {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (this.rxPacketHandler != null) {
                this.rxPacketHandler.interrupt();
                try {
                    this.rxPacketHandler.join();
                }
                catch (InterruptedException ie) {
                    this.rxPacketHandler.interrupt();
                }
                this.rxPacketHandler = null;
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                    AmityLog.INSTANCE.tag(TAG).d("socket closed", new Object[0]);
                } else {
                    AmityLog.INSTANCE.tag(TAG).e("shutdown(): failed to close socket", new Object[0]);
                }
            }
            catch (IOException ex) {
                AmityLog.INSTANCE.tag(TAG).e("shutdown(): failed to close socket", new Object[]{ex});
            }
            this.mHandler.notifyRtmpDisconnected();
        }
        this.reset();
    }

    private void reset() {
        this.connected = false;
        this.publishPermitted = false;
        this.tcUrl = null;
        this.swfUrl = null;
        this.pageUrl = null;
        this.appName = null;
        this.streamName = null;
        this.publishType = null;
        this.currentStreamId = 0;
        this.transactionIdCounter = 0;
        this.videoFrameCacheNumber.set(0);
        this.socketExceptionCause = "";
        this.serverIpAddr = null;
        this.serverPid = null;
        this.serverId = null;
        this.socket = null;
        this.rtmpSessionInfo = null;
        this.rtmpDecoder = null;
    }

    @Override
    public void publishAudioData(byte[] data, int size, int dts) {
        if (data == null || data.length == 0 || dts < 0) {
            this.mHandler.notifyRtmpIllegalArgumentException(new IllegalArgumentException("Invalid Audio Data"));
            return;
        }
        if (!this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not connected to RTMP server"));
            return;
        }
        if (this.currentStreamId == 0) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("No current stream object exists"));
            return;
        }
        if (!this.publishPermitted) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not get _result(Netstream.Publish.Start)"));
            return;
        }
        Audio audio = new Audio();
        audio.setData(data, size);
        audio.getHeader().setAbsoluteTimestamp(dts);
        audio.getHeader().setMessageStreamId(this.currentStreamId);
        this.sendRtmpPacket(audio);
        this.calcAudioBitrate(audio.getHeader().getPacketLength());
        this.mHandler.notifyRtmpAudioStreaming();
    }

    @Override
    public void publishVideoData(byte[] data, int size, int dts) {
        if (data == null || data.length == 0 || dts < 0) {
            this.mHandler.notifyRtmpIllegalArgumentException(new IllegalArgumentException("Invalid Video Data"));
            return;
        }
        if (!this.connected) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not connected to RTMP server"));
            return;
        }
        if (this.currentStreamId == 0) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("No current stream object exists"));
            return;
        }
        if (!this.publishPermitted) {
            this.mHandler.notifyRtmpIllegalStateException(new IllegalStateException("Not get _result(Netstream.Publish.Start)"));
            return;
        }
        Video video = new Video();
        video.setData(data, size);
        video.getHeader().setAbsoluteTimestamp(dts);
        video.getHeader().setMessageStreamId(this.currentStreamId);
        this.sendRtmpPacket(video);
        this.videoFrameCacheNumber.decrementAndGet();
        this.calcVideoFpsAndBitrate(video.getHeader().getPacketLength());
        this.mHandler.notifyRtmpVideoStreaming();
    }

    private void calcVideoFpsAndBitrate(int length) {
        this.videoDataLength += length;
        if (this.videoFrameCount == 0) {
            this.videoLastTimeMillis = System.nanoTime() / 1000000L;
            ++this.videoFrameCount;
        } else if (++this.videoFrameCount >= 48) {
            long diffTimeMillis = System.nanoTime() / 1000000L - this.videoLastTimeMillis;
            this.mHandler.notifyRtmpVideoFpsChanged((double)this.videoFrameCount * 1000.0 / (double)diffTimeMillis);
            this.mHandler.notifyRtmpVideoBitrateChanged((double)this.videoDataLength * 8.0 * 1000.0 / (double)diffTimeMillis);
            this.videoFrameCount = 0;
            this.videoDataLength = 0;
        }
    }

    private void calcAudioBitrate(int length) {
        this.audioDataLength += length;
        if (this.audioFrameCount == 0) {
            this.audioLastTimeMillis = System.nanoTime() / 1000000L;
            ++this.audioFrameCount;
        } else if (++this.audioFrameCount >= 48) {
            long diffTimeMillis = System.nanoTime() / 1000000L - this.audioLastTimeMillis;
            this.mHandler.notifyRtmpAudioBitrateChanged((double)this.audioDataLength * 8.0 * 1000.0 / (double)diffTimeMillis);
            this.audioFrameCount = 0;
            this.audioDataLength = 0;
        }
    }

    private void sendRtmpPacket(RtmpPacket rtmpPacket) {
        try {
            ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(rtmpPacket.getHeader().getChunkStreamId());
            chunkStreamInfo.setPrevHeaderTx(rtmpPacket.getHeader());
            if (!(rtmpPacket instanceof Video) && !(rtmpPacket instanceof Audio)) {
                rtmpPacket.getHeader().setAbsoluteTimestamp((int)chunkStreamInfo.markAbsoluteTimestampTx());
            }
            rtmpPacket.writeTo(this.outputStream, this.rtmpSessionInfo.getTxChunkSize(), chunkStreamInfo);
            AmityLog.INSTANCE.tag(TAG).d("wrote packet: " + rtmpPacket + ", size: " + rtmpPacket.getHeader().getPacketLength(), new Object[0]);
            if (rtmpPacket instanceof Command) {
                this.rtmpSessionInfo.addInvokedCommand(((Command)rtmpPacket).getTransactionId(), ((Command)rtmpPacket).getCommandName());
            }
            this.outputStream.flush();
        }
        catch (SocketException se) {
            if (!this.socketExceptionCause.contentEquals(se.getMessage())) {
                this.socketExceptionCause = se.getMessage();
                AmityLog.INSTANCE.tag(TAG).e("Caught SocketException during write loop, shutting down: " + se.getMessage(), new Object[0]);
                this.mHandler.notifyRtmpSocketException(se);
            }
        }
        catch (IOException ioe) {
            AmityLog.INSTANCE.tag(TAG).e("Caught IOException during write loop, shutting down: " + ioe.getMessage(), new Object[0]);
            this.mHandler.notifyRtmpIOException(ioe);
        }
    }

    private void handleRxPacketLoop() throws IOException {
        block16: while (!Thread.interrupted()) {
            try {
                RtmpPacket rtmpPacket = this.rtmpDecoder.readPacket(this.inputStream);
                if (rtmpPacket == null) continue;
                switch (rtmpPacket.getHeader().getMessageType()) {
                    case ABORT: {
                        this.rtmpSessionInfo.getChunkStreamInfo(((Abort)rtmpPacket).getChunkStreamId()).clearStoredChunks();
                        continue block16;
                    }
                    case USER_CONTROL_MESSAGE: {
                        UserControl user = (UserControl)rtmpPacket;
                        switch (user.getType()) {
                            case STREAM_BEGIN: {
                                AmityLog.INSTANCE.tag(TAG).d("handleRxPacketLoop(): Receive STREAM_BEGIN", new Object[0]);
                                continue block16;
                            }
                            case PING_REQUEST: {
                                ChunkStreamInfo channelInfo = this.rtmpSessionInfo.getChunkStreamInfo(2);
                                AmityLog.INSTANCE.tag(TAG).d("handleRxPacketLoop(): Sending PONG reply..", new Object[0]);
                                UserControl pong = new UserControl(user, channelInfo);
                                this.sendRtmpPacket(pong);
                                continue block16;
                            }
                            case STREAM_EOF: {
                                AmityLog.INSTANCE.tag(TAG).i("handleRxPacketLoop(): Stream EOF reached, closing RTMP writer...", new Object[0]);
                                continue block16;
                            }
                        }
                        continue block16;
                    }
                    case WINDOW_ACKNOWLEDGEMENT_SIZE: {
                        WindowAckSize windowAckSize = (WindowAckSize)rtmpPacket;
                        int size = windowAckSize.getAcknowledgementWindowSize();
                        AmityLog.INSTANCE.tag(TAG).d("handleRxPacketLoop(): Setting acknowledgement window size: " + size, new Object[0]);
                        this.rtmpSessionInfo.setAcknowledgmentWindowSize(size);
                        continue block16;
                    }
                    case SET_PEER_BANDWIDTH: {
                        SetPeerBandwidth bw = (SetPeerBandwidth)rtmpPacket;
                        this.rtmpSessionInfo.setAcknowledgmentWindowSize(bw.getAcknowledgementWindowSize());
                        int acknowledgementWindowsize = this.rtmpSessionInfo.getAcknowledgementWindowSize();
                        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(2);
                        AmityLog.INSTANCE.tag(TAG).d("handleRxPacketLoop(): Send acknowledgement window size: " + acknowledgementWindowsize, new Object[0]);
                        this.sendRtmpPacket(new WindowAckSize(acknowledgementWindowsize, chunkStreamInfo));
                        this.socket.setSendBufferSize(acknowledgementWindowsize);
                        continue block16;
                    }
                    case COMMAND_AMF0: {
                        this.handleRxInvoke((Command)rtmpPacket);
                        continue block16;
                    }
                }
                AmityLog.INSTANCE.tag(TAG).w("handleRxPacketLoop(): Not handling unimplemented/unknown packet of type: " + (Object)((Object)rtmpPacket.getHeader().getMessageType()), new Object[0]);
            }
            catch (EOFException eof) {
                Thread.currentThread().interrupt();
            }
            catch (SocketException se) {
                AmityLog.INSTANCE.tag(TAG).e("Caught SocketException while reading/decoding packet, shutting down: " + se.getMessage(), new Object[0]);
                this.mHandler.notifyRtmpSocketException(se);
            }
            catch (IOException ioe) {
                AmityLog.INSTANCE.tag(TAG).e("Caught exception while reading/decoding packet, shutting down: " + ioe.getMessage(), new Object[0]);
                this.mHandler.notifyRtmpIOException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRxInvoke(Command invoke) throws IOException {
        String commandName = invoke.getCommandName();
        if (commandName.equals("_result")) {
            String method = this.rtmpSessionInfo.takeInvokedCommand(invoke.getTransactionId());
            AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke: Got result for invoked method: " + method, new Object[0]);
            if ("connect".equals(method)) {
                this.srsServerInfo = this.onSrsServerInfo(invoke);
                this.connected = true;
                Object object = this.connectingLock;
                synchronized (object) {
                    this.connectingLock.notifyAll();
                }
            } else if ("createStream".contains(method)) {
                this.currentStreamId = (int)((AmfNumber)invoke.getData().get(1)).getValue();
                AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): Stream ID to publish: " + this.currentStreamId, new Object[0]);
                if (this.streamName != null && this.publishType != null) {
                    this.fmlePublish();
                }
            } else if ("releaseStream".contains(method)) {
                AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): 'releaseStream'", new Object[0]);
            } else if ("FCPublish".contains(method)) {
                AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): 'FCPublish'", new Object[0]);
            } else {
                AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): '_result' message received for unknown method: " + method, new Object[0]);
            }
        } else if (commandName.equals("onBWDone")) {
            AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): 'onBWDone'", new Object[0]);
        } else if (commandName.equals("onFCPublish")) {
            AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): 'onFCPublish'", new Object[0]);
        } else if (commandName.equals("onStatus")) {
            String code = ((AmfString)((AmfObject)invoke.getData().get(1)).getProperty("code")).getValue();
            AmityLog.INSTANCE.tag(TAG).d("handleRxInvoke(): onStatus " + code, new Object[0]);
            if (code.equals("NetStream.Publish.Start")) {
                this.onMetaData();
                this.publishPermitted = true;
                Object object = this.publishLock;
                synchronized (object) {
                    this.publishLock.notifyAll();
                }
            }
        } else {
            AmityLog.INSTANCE.tag(TAG).e("handleRxInvoke(): Unknown/unhandled server invoke: " + invoke, new Object[0]);
        }
    }

    private String onSrsServerInfo(Command invoke) {
        AmfObject objData = (AmfObject)invoke.getData().get(1);
        if (objData.getProperty("data") instanceof AmfObject) {
            objData = (AmfObject)objData.getProperty("data");
            this.serverIpAddr = (AmfString)objData.getProperty("srs_server_ip");
            this.serverPid = (AmfNumber)objData.getProperty("srs_pid");
            this.serverId = (AmfNumber)objData.getProperty("srs_id");
        }
        String info = "";
        info = info + (this.serverIpAddr == null ? "" : " ip: " + this.serverIpAddr.getValue());
        info = info + (this.serverPid == null ? "" : " pid: " + (int)this.serverPid.getValue());
        info = info + (this.serverId == null ? "" : " id: " + (int)this.serverId.getValue());
        return info;
    }

    @Override
    public AtomicInteger getVideoFrameCacheNumber() {
        return this.videoFrameCacheNumber;
    }

    @Override
    public final String getServerIpAddr() {
        return this.serverIpAddr == null ? null : this.serverIpAddr.getValue();
    }

    @Override
    public final int getServerPid() {
        return this.serverPid == null ? 0 : (int)this.serverPid.getValue();
    }

    @Override
    public final int getServerId() {
        return this.serverId == null ? 0 : (int)this.serverId.getValue();
    }

    @Override
    public void setVideoResolution(int width, int height) {
        this.videoWidth = width;
        this.videoHeight = height;
    }
}

