/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.yasea;

import android.hardware.Camera;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.os.Process;
import com.amity.github.faucamp.simplertmp.RtmpHandler;
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution;
import com.amity.socialcloud.sdk.video.model.AmityStreamBroadcasterState;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.io.File;
import net.ossrs.yasea.SrsCameraView;
import net.ossrs.yasea.SrsEncodeHandler;
import net.ossrs.yasea.SrsEncoder;
import net.ossrs.yasea.SrsFlvMuxer;
import net.ossrs.yasea.SrsMp4Muxer;
import net.ossrs.yasea.SrsRecordHandler;

public class SrsPublisher {
    private static AudioRecord mic;
    private static AcousticEchoCanceler aec;
    private static AutomaticGainControl agc;
    private byte[] mPcmBuffer = new byte[4096];
    private Thread aworker;
    private SrsCameraView mCameraView;
    private boolean sendVideoOnly = false;
    private boolean sendAudioOnly = false;
    private int videoFrameCount;
    private long lastTimeMillis;
    private double mSamplingFps;
    private SrsFlvMuxer mFlvMuxer;
    private SrsMp4Muxer mMp4Muxer;
    private SrsEncoder mEncoder;
    private PublishSubject<AmityStreamBroadcasterState> statusSubject;

    public SrsPublisher(SrsCameraView view, PublishSubject<AmityStreamBroadcasterState> statusSubject) {
        this.statusSubject = statusSubject;
        this.mCameraView = view;
        this.mCameraView.setPreviewCallback(new SrsCameraView.PreviewCallback(){

            @Override
            public void onGetRgbaFrame(byte[] data, int width, int height) {
                SrsPublisher.this.calcSamplingFps();
                if (!SrsPublisher.this.sendAudioOnly) {
                    SrsPublisher.this.mEncoder.onGetRgbaFrame(data, width, height);
                }
            }
        });
    }

    public PublishSubject<AmityStreamBroadcasterState> getStatusSubject() {
        return this.statusSubject;
    }

    private void calcSamplingFps() {
        if (this.videoFrameCount == 0) {
            this.lastTimeMillis = System.nanoTime() / 1000000L;
            ++this.videoFrameCount;
        } else if (++this.videoFrameCount >= 30) {
            long diffTimeMillis = System.nanoTime() / 1000000L - this.lastTimeMillis;
            this.mSamplingFps = (double)this.videoFrameCount * 1000.0 / (double)diffTimeMillis;
            this.videoFrameCount = 0;
        }
    }

    public void startCamera() {
        this.mCameraView.startCamera();
        this.mCameraView.setVisibility(0);
    }

    public void stopCamera() {
        this.mCameraView.stopCamera();
    }

    public void startAudio() {
        mic = this.mEncoder.chooseAudioRecord();
        if (mic == null) {
            return;
        }
        if (AcousticEchoCanceler.isAvailable() && (aec = AcousticEchoCanceler.create((int)mic.getAudioSessionId())) != null) {
            aec.setEnabled(true);
        }
        if (AutomaticGainControl.isAvailable() && (agc = AutomaticGainControl.create((int)mic.getAudioSessionId())) != null) {
            agc.setEnabled(true);
        }
        this.aworker = new Thread(new Runnable(){

            @Override
            public void run() {
                Process.setThreadPriority((int)-16);
                mic.startRecording();
                while (!Thread.interrupted()) {
                    if (SrsPublisher.this.sendVideoOnly) {
                        SrsPublisher.this.mEncoder.onGetPcmFrame(SrsPublisher.this.mPcmBuffer, SrsPublisher.this.mPcmBuffer.length);
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    int size = mic.read(SrsPublisher.this.mPcmBuffer, 0, SrsPublisher.this.mPcmBuffer.length);
                    if (size <= 0) continue;
                    try {
                        SrsPublisher.this.mEncoder.onGetPcmFrame(SrsPublisher.this.mPcmBuffer, size);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        });
        this.aworker.start();
    }

    public void stopAudio() {
        if (this.aworker != null) {
            this.aworker.interrupt();
            try {
                this.aworker.join();
            }
            catch (InterruptedException e) {
                this.aworker.interrupt();
            }
            this.aworker = null;
        }
        if (mic != null) {
            mic.setRecordPositionUpdateListener(null);
            mic.stop();
            mic.release();
            mic = null;
        }
        if (aec != null) {
            aec.setEnabled(false);
            aec.release();
            aec = null;
        }
        if (agc != null) {
            agc.setEnabled(false);
            agc.release();
            agc = null;
        }
    }

    public void startEncode() {
        if (!this.mEncoder.start()) {
            return;
        }
        this.mCameraView.enableEncoding();
        this.startAudio();
    }

    public void stopEncode() {
        this.stopAudio();
        this.stopCamera();
        this.mEncoder.stop();
    }

    public void pauseEncode() {
        this.stopAudio();
        this.mCameraView.disableEncoding();
        this.mCameraView.stopTorch();
    }

    private void resumeEncode() {
        this.startAudio();
        this.mCameraView.enableEncoding();
    }

    public void startPublish(String rtmpUrl) {
        if (this.mFlvMuxer != null) {
            this.mFlvMuxer.start(rtmpUrl);
            this.mFlvMuxer.setVideoResolution(this.mEncoder.getOutputWidth(), this.mEncoder.getOutputHeight());
            this.startEncode();
        }
    }

    public void resumePublish() {
        if (this.mFlvMuxer != null) {
            this.mEncoder.resume();
            this.resumeEncode();
        }
    }

    public void stopPublish() {
        if (this.mFlvMuxer != null) {
            this.stopEncode();
            this.mFlvMuxer.stop();
        }
    }

    public void pausePublish() {
        if (this.mFlvMuxer != null) {
            this.mEncoder.pause();
            this.pauseEncode();
        }
    }

    public boolean startRecord(String recPath) {
        return this.mMp4Muxer != null && this.mMp4Muxer.record(new File(recPath));
    }

    public void stopRecord() {
        if (this.mMp4Muxer != null) {
            this.mMp4Muxer.stop();
        }
    }

    public void pauseRecord() {
        if (this.mMp4Muxer != null) {
            this.mMp4Muxer.pause();
        }
    }

    public void resumeRecord() {
        if (this.mMp4Muxer != null) {
            this.mMp4Muxer.resume();
        }
    }

    public boolean isAllFramesUploaded() {
        return this.mFlvMuxer.getVideoFrameCacheNumber().get() == 0;
    }

    public int getVideoFrameCacheCount() {
        if (this.mFlvMuxer != null) {
            return this.mFlvMuxer.getVideoFrameCacheNumber().get();
        }
        return 0;
    }

    public void switchToSoftEncoder() {
        this.mEncoder.switchToSoftEncoder();
    }

    public void switchToHardEncoder() {
        this.mEncoder.switchToHardEncoder();
    }

    public boolean isSoftEncoder() {
        return this.mEncoder.isSoftEncoder();
    }

    public int getPreviewWidth() {
        return this.mEncoder.getPreviewWidth();
    }

    public int getPreviewHeight() {
        return this.mEncoder.getPreviewHeight();
    }

    public double getmSamplingFps() {
        return this.mSamplingFps;
    }

    public int getCameraId() {
        return this.mCameraView.getCameraId();
    }

    public Camera getCamera() {
        return this.mCameraView.getCamera();
    }

    public void setPreviewResolution(AmityBroadcastResolution resolution) {
        int[] resolutionArray = this.mCameraView.setPreviewResolution(resolution.getWidth(), resolution.getHeight());
        this.mEncoder.setPreviewResolution(resolutionArray[0], resolutionArray[1]);
    }

    public void setOutputResolution(AmityBroadcastResolution resolution) {
        int height;
        int width = resolution.getHeight();
        if (width <= (height = resolution.getWidth())) {
            this.mEncoder.setPortraitResolution(width, height);
        } else {
            this.mEncoder.setLandscapeResolution(width, height);
        }
    }

    public void setScreenOrientation(int orientation) {
        this.mCameraView.setPreviewOrientation(orientation);
        this.mEncoder.setScreenOrientation(orientation);
    }

    public void setVideoBitrate(AmityBroadcastResolution resolution) {
        this.mEncoder.setVideoBitrate(resolution);
    }

    public void setSendVideoOnly(boolean flag) {
        if (mic != null) {
            if (flag) {
                mic.stop();
                this.mPcmBuffer = new byte[4096];
            } else {
                mic.startRecording();
            }
        }
        this.sendVideoOnly = flag;
    }

    public void setSendAudioOnly(boolean flag) {
        this.sendAudioOnly = flag;
    }

    public void switchCameraFace(int id) {
        this.mCameraView.stopCamera();
        this.mCameraView.setCameraId(id);
        if (id == 0) {
            this.mEncoder.setCameraBackFace();
        } else {
            this.mEncoder.setCameraFrontFace();
        }
        if (this.mEncoder != null && this.mEncoder.isEnabled()) {
            this.mCameraView.enableEncoding();
        }
        this.mCameraView.startCamera();
    }

    public void setRtmpHandler(RtmpHandler handler) {
        this.mFlvMuxer = new SrsFlvMuxer(handler);
        if (this.mEncoder != null) {
            this.mEncoder.setFlvMuxer(this.mFlvMuxer);
        }
    }

    public void setRecordHandler(SrsRecordHandler handler) {
        this.mMp4Muxer = new SrsMp4Muxer(handler);
        if (this.mEncoder != null) {
            this.mEncoder.setMp4Muxer(this.mMp4Muxer);
        }
    }

    public void setEncodeHandler(SrsEncodeHandler handler) {
        this.mEncoder = new SrsEncoder(handler);
        if (this.mFlvMuxer != null) {
            this.mEncoder.setFlvMuxer(this.mFlvMuxer);
        }
        if (this.mMp4Muxer != null) {
            this.mEncoder.setMp4Muxer(this.mMp4Muxer);
        }
    }
}

