/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.base.gpuimage;

import android.opengl.GLES20;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import net.ossrs.yasea.R;

public class GPUImageSharpenFilter
extends GPUImageFilter {
    private int mSharpnessLocation;
    private float mSharpness;
    private int mImageWidthFactorLocation;
    private int mImageHeightFactorLocation;

    public GPUImageSharpenFilter() {
        this(0.0f);
    }

    public GPUImageSharpenFilter(float sharpness) {
        super(MagicFilterType.SHARPEN, R.raw.vertex_sharpen, R.raw.sharpen);
        this.mSharpness = sharpness;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mSharpnessLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"sharpness");
        this.mImageWidthFactorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"imageWidthFactor");
        this.mImageHeightFactorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"imageHeightFactor");
        this.setSharpness(this.mSharpness);
    }

    @Override
    public void onInputSizeChanged(int width, int height) {
        super.onInputSizeChanged(width, height);
        this.setFloat(this.mImageWidthFactorLocation, 1.0f / (float)width);
        this.setFloat(this.mImageHeightFactorLocation, 1.0f / (float)height);
    }

    public void setSharpness(float sharpness) {
        this.mSharpness = sharpness;
        this.setFloat(this.mSharpnessLocation, this.mSharpness);
    }
}

