/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.boxes.piff;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TfrfBox
extends AbstractFullBox {
    public List<Entry> entries = new ArrayList<Entry>();

    public TfrfBox() {
        super("uuid");
    }

    @Override
    public byte[] getUserType() {
        return new byte[]{-44, -128, 126, -14, -54, 57, 70, -107, -114, 84, 38, -53, -98, 70, -89, -97};
    }

    @Override
    protected long getContentSize() {
        return 5 + this.entries.size() * (this.getVersion() == 1 ? 16 : 8);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt8(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            if (this.getVersion() == 1) {
                IsoTypeWriter.writeUInt64(byteBuffer, entry.fragmentAbsoluteTime);
                IsoTypeWriter.writeUInt64(byteBuffer, entry.fragmentAbsoluteDuration);
                continue;
            }
            IsoTypeWriter.writeUInt32(byteBuffer, entry.fragmentAbsoluteTime);
            IsoTypeWriter.writeUInt32(byteBuffer, entry.fragmentAbsoluteDuration);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        int fragmentCount = IsoTypeReader.readUInt8(content);
        for (int i = 0; i < fragmentCount; ++i) {
            Entry entry = new Entry();
            if (this.getVersion() == 1) {
                entry.fragmentAbsoluteTime = IsoTypeReader.readUInt64(content);
                entry.fragmentAbsoluteDuration = IsoTypeReader.readUInt64(content);
            } else {
                entry.fragmentAbsoluteTime = IsoTypeReader.readUInt32(content);
                entry.fragmentAbsoluteDuration = IsoTypeReader.readUInt32(content);
            }
            this.entries.add(entry);
        }
    }

    public long getFragmentCount() {
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TfrfBox");
        sb.append("{entries=").append(this.entries);
        sb.append('}');
        return sb.toString();
    }

    public class Entry {
        long fragmentAbsoluteTime;
        long fragmentAbsoluteDuration;

        public long getFragmentAbsoluteTime() {
            return this.fragmentAbsoluteTime;
        }

        public long getFragmentAbsoluteDuration() {
            return this.fragmentAbsoluteDuration;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry");
            sb.append("{fragmentAbsoluteTime=").append(this.fragmentAbsoluteTime);
            sb.append(", fragmentAbsoluteDuration=").append(this.fragmentAbsoluteDuration);
            sb.append('}');
            return sb.toString();
        }
    }
}

