/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes.vodafone;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.coremedia.iso.Utf8;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class ContentDistributorIdBox
extends AbstractFullBox {
    public static final String TYPE = "cdis";
    private String language;
    private String contentDistributorId;

    public ContentDistributorIdBox() {
        super(TYPE);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getContentDistributorId() {
        return this.contentDistributorId;
    }

    @Override
    protected long getContentSize() {
        return 2 + Utf8.utf8StringLengthInBytes(this.contentDistributorId) + 5;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.language = IsoTypeReader.readIso639(content);
        this.contentDistributorId = IsoTypeReader.readString(content);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeIso639(byteBuffer, this.language);
        byteBuffer.put(Utf8.convert(this.contentDistributorId));
        byteBuffer.put((byte)0);
    }

    public String toString() {
        return "ContentDistributorIdBox[language=" + this.getLanguage() + ";contentDistributorId=" + this.getContentDistributorId() + "]";
    }
}

