/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.yasea;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import net.ossrs.yasea.SrsEncodeHandler;
import net.ossrs.yasea.SrsFlvMuxer;
import net.ossrs.yasea.SrsMp4Muxer;

public class SrsEncoder {
    private static final String TAG = "SrsEncoder";
    public static final String VCODEC = "video/avc";
    public static final String ACODEC = "audio/mp4a-latm";
    public static String x264Preset = "veryfast";
    public static int vPrevWidth = 640;
    public static int vPrevHeight = 360;
    public static int vPortraitWidth = 360;
    public static int vPortraitHeight = 640;
    public static int vLandscapeWidth = 640;
    public static int vLandscapeHeight = 360;
    public static int vOutWidth = 360;
    public static int vOutHeight = 640;
    public static int vBitrate = 1228800;
    public static final int VFPS = 30;
    public static final int VGOP = 30;
    public static final int ASAMPLERATE = 44100;
    public static int aChannelConfig = 12;
    public static final int ABITRATE = 65536;
    private static final int KBPS = 1024;
    private SrsEncodeHandler mHandler;
    private SrsFlvMuxer flvMuxer;
    private SrsMp4Muxer mp4Muxer;
    private MediaCodecInfo vmci;
    private MediaCodec vencoder;
    private MediaCodec aencoder;
    private boolean networkWeakTriggered = false;
    private boolean mCameraFaceFront = true;
    private boolean useSoftEncoder = false;
    private boolean canSoftEncode = false;
    private long mPresentTimeUs;
    private long mPausetime;
    private int mVideoColorFormat;
    private int videoFlvTrack;
    private int videoMp4Track;
    private int audioFlvTrack;
    private int audioMp4Track;

    public SrsEncoder(SrsEncodeHandler handler) {
        this.mHandler = handler;
        this.mVideoColorFormat = this.chooseVideoEncoder();
    }

    public void setFlvMuxer(SrsFlvMuxer flvMuxer) {
        this.flvMuxer = flvMuxer;
    }

    public void setMp4Muxer(SrsMp4Muxer mp4Muxer) {
        this.mp4Muxer = mp4Muxer;
    }

    public boolean start() {
        if (this.flvMuxer == null || this.mp4Muxer == null) {
            return false;
        }
        this.mPresentTimeUs = System.nanoTime() / 1000L;
        if (this.useSoftEncoder || vOutWidth % 32 == 0 && vOutHeight % 32 == 0 || this.vmci.getName().contains("MTK")) {
            // empty if block
        }
        this.setEncoderResolution(vOutWidth, vOutHeight);
        this.setEncoderFps(30);
        this.setEncoderGop(30);
        this.setEncoderBitrate(vBitrate);
        this.setEncoderPreset(x264Preset);
        if (this.useSoftEncoder) {
            this.canSoftEncode = this.openSoftEncoder();
            if (!this.canSoftEncode) {
                return false;
            }
        }
        try {
            this.aencoder = MediaCodec.createEncoderByType((String)ACODEC);
        }
        catch (IOException e) {
            AmityLog.INSTANCE.tag(TAG).e("create aencoder failed.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        int ach = aChannelConfig == 12 ? 2 : 1;
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)ACODEC, (int)44100, (int)ach);
        audioFormat.setInteger("bitrate", 65536);
        audioFormat.setInteger("max-input-size", 0);
        this.aencoder.configure(audioFormat, null, null, 1);
        this.audioFlvTrack = this.flvMuxer.addTrack(audioFormat);
        this.audioMp4Track = this.mp4Muxer.addTrack(audioFormat);
        try {
            this.vencoder = MediaCodec.createByCodecName((String)this.vmci.getName());
        }
        catch (IOException e) {
            AmityLog.INSTANCE.tag(TAG).e("create vencoder failed.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        MediaFormat videoFormat = MediaFormat.createVideoFormat((String)VCODEC, (int)vOutWidth, (int)vOutHeight);
        videoFormat.setInteger("color-format", this.mVideoColorFormat);
        videoFormat.setInteger("max-input-size", 0);
        videoFormat.setInteger("bitrate", vBitrate);
        videoFormat.setInteger("frame-rate", 30);
        videoFormat.setInteger("i-frame-interval", 1);
        this.vencoder.configure(videoFormat, null, null, 1);
        this.videoFlvTrack = this.flvMuxer.addTrack(videoFormat);
        this.videoMp4Track = this.mp4Muxer.addTrack(videoFormat);
        this.vencoder.start();
        this.aencoder.start();
        return true;
    }

    public void pause() {
        this.mPausetime = System.nanoTime() / 1000L;
    }

    public void resume() {
        long resumeTime = System.nanoTime() / 1000L - this.mPausetime;
        this.mPresentTimeUs += resumeTime;
        this.mPausetime = 0L;
    }

    public void stop() {
        if (this.useSoftEncoder) {
            this.closeSoftEncoder();
            this.canSoftEncode = false;
        }
        if (this.aencoder != null) {
            AmityLog.INSTANCE.tag(TAG).i("stop aencoder", new Object[0]);
            try {
                this.aencoder.stop();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.aencoder.release();
            this.aencoder = null;
        }
        if (this.vencoder != null) {
            AmityLog.INSTANCE.tag(TAG).i("stop vencoder", new Object[0]);
            try {
                this.vencoder.stop();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.vencoder.release();
            this.vencoder = null;
        }
    }

    public void setCameraFrontFace() {
        this.mCameraFaceFront = true;
    }

    public void setCameraBackFace() {
        this.mCameraFaceFront = false;
    }

    public void switchToSoftEncoder() {
        this.useSoftEncoder = true;
    }

    public void switchToHardEncoder() {
        this.useSoftEncoder = false;
    }

    public boolean isSoftEncoder() {
        return this.useSoftEncoder;
    }

    public boolean canHardEncode() {
        return this.vencoder != null;
    }

    public boolean canSoftEncode() {
        return this.canSoftEncode;
    }

    public boolean isEnabled() {
        return this.canHardEncode() || this.canSoftEncode();
    }

    public void setPreviewResolution(int width, int height) {
        vPrevWidth = width;
        vPrevHeight = height;
    }

    public void setPortraitResolution(int width, int height) {
        vOutWidth = width;
        vOutHeight = height;
        vPortraitWidth = width;
        vPortraitHeight = height;
        vLandscapeWidth = height;
        vLandscapeHeight = width;
    }

    public void setLandscapeResolution(int width, int height) {
        vOutWidth = width;
        vOutHeight = height;
        vLandscapeWidth = width;
        vLandscapeHeight = height;
        vPortraitWidth = height;
        vPortraitHeight = width;
    }

    public void setVideoBitrate(AmityBroadcastResolution resolution) {
        vBitrate = resolution.getBitrate() * 1024;
        x264Preset = "veryfast";
    }

    public int getPreviewWidth() {
        return vPrevWidth;
    }

    public int getPreviewHeight() {
        return vPrevHeight;
    }

    public int getOutputWidth() {
        return vOutWidth;
    }

    public int getOutputHeight() {
        return vOutHeight;
    }

    public void setScreenOrientation(int orientation) {
        if (orientation == 1) {
            vOutWidth = vPortraitWidth;
            vOutHeight = vPortraitHeight;
        } else if (orientation == 2) {
            vOutWidth = vLandscapeWidth;
            vOutHeight = vLandscapeHeight;
        }
        if (this.useSoftEncoder || vOutWidth % 32 == 0 && vOutHeight % 32 == 0 || this.vmci.getName().contains("MTK")) {
            // empty if block
        }
        this.setEncoderResolution(vOutWidth, vOutHeight);
    }

    private void onProcessedYuvFrame(byte[] yuvFrame, long pts) {
        MediaCodec.BufferInfo vebi;
        int outBufferIndex;
        ByteBuffer[] inBuffers = this.vencoder.getInputBuffers();
        ByteBuffer[] outBuffers = this.vencoder.getOutputBuffers();
        int inBufferIndex = this.vencoder.dequeueInputBuffer(-1L);
        if (inBufferIndex >= 0) {
            ByteBuffer bb = inBuffers[inBufferIndex];
            bb.clear();
            bb.put(yuvFrame, 0, yuvFrame.length);
            this.vencoder.queueInputBuffer(inBufferIndex, 0, yuvFrame.length, pts, 0);
        }
        while ((outBufferIndex = this.vencoder.dequeueOutputBuffer(vebi = new MediaCodec.BufferInfo(), 0L)) >= 0) {
            ByteBuffer bb = outBuffers[outBufferIndex];
            this.onEncodedAnnexbFrame(bb, vebi);
            this.vencoder.releaseOutputBuffer(outBufferIndex, false);
        }
    }

    private void onSoftEncodedData(byte[] es, long pts, boolean isKeyFrame) {
        ByteBuffer bb = ByteBuffer.wrap(es);
        MediaCodec.BufferInfo vebi = new MediaCodec.BufferInfo();
        vebi.offset = 0;
        vebi.size = es.length;
        vebi.presentationTimeUs = pts;
        vebi.flags = isKeyFrame ? 1 : 0;
        this.onEncodedAnnexbFrame(bb, vebi);
    }

    private void onEncodedAnnexbFrame(ByteBuffer es, MediaCodec.BufferInfo bi) {
        this.mp4Muxer.writeSampleData(this.videoMp4Track, es.duplicate(), bi);
        this.flvMuxer.writeSampleData(this.videoFlvTrack, es, bi);
    }

    private void onEncodedAacFrame(ByteBuffer es, MediaCodec.BufferInfo bi) {
        this.mp4Muxer.writeSampleData(this.audioMp4Track, es.duplicate(), bi);
        this.flvMuxer.writeSampleData(this.audioFlvTrack, es, bi);
    }

    public void onGetPcmFrame(byte[] data, int size) {
        AtomicInteger videoFrameCacheNumber = this.flvMuxer.getVideoFrameCacheNumber();
        if (videoFrameCacheNumber != null && videoFrameCacheNumber.get() < 30) {
            MediaCodec.BufferInfo aebi;
            int outBufferIndex;
            ByteBuffer[] inBuffers = this.aencoder.getInputBuffers();
            ByteBuffer[] outBuffers = this.aencoder.getOutputBuffers();
            int inBufferIndex = this.aencoder.dequeueInputBuffer(-1L);
            if (inBufferIndex >= 0) {
                ByteBuffer bb = inBuffers[inBufferIndex];
                bb.clear();
                bb.put(data, 0, size);
                long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
                this.aencoder.queueInputBuffer(inBufferIndex, 0, size, pts, 0);
            }
            while ((outBufferIndex = this.aencoder.dequeueOutputBuffer(aebi = new MediaCodec.BufferInfo(), 0L)) >= 0) {
                ByteBuffer bb = outBuffers[outBufferIndex];
                this.onEncodedAacFrame(bb, aebi);
                this.aencoder.releaseOutputBuffer(outBufferIndex, false);
            }
        }
    }

    public void onGetRgbaFrame(byte[] data, int width, int height) {
        AtomicInteger videoFrameCacheNumber = this.flvMuxer.getVideoFrameCacheNumber();
        if (videoFrameCacheNumber != null && videoFrameCacheNumber.get() < 30) {
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            if (this.useSoftEncoder) {
                this.swRgbaFrame(data, width, height, pts);
            } else {
                byte[] processedData = this.hwRgbaFrame(data, width, height);
                if (processedData != null) {
                    this.onProcessedYuvFrame(processedData, pts);
                } else {
                    this.mHandler.notifyEncodeIllegalArgumentException(new IllegalArgumentException("libyuv failure"));
                }
            }
            if (this.networkWeakTriggered) {
                this.networkWeakTriggered = false;
                this.mHandler.notifyNetworkResume();
            }
        } else {
            this.mHandler.notifyNetworkWeak();
            this.networkWeakTriggered = true;
        }
    }

    public void onGetYuvNV21Frame(byte[] data, int width, int height, Rect boundingBox) {
        AtomicInteger videoFrameCacheNumber = this.flvMuxer.getVideoFrameCacheNumber();
        if (videoFrameCacheNumber != null && videoFrameCacheNumber.get() < 30) {
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            if (this.useSoftEncoder) {
                throw new UnsupportedOperationException("Not implemented");
            }
            byte[] processedData = this.hwYUVNV21FrameScaled(data, width, height, boundingBox);
            if (processedData != null) {
                this.onProcessedYuvFrame(processedData, pts);
            } else {
                this.mHandler.notifyEncodeIllegalArgumentException(new IllegalArgumentException("libyuv failure"));
            }
            if (this.networkWeakTriggered) {
                this.networkWeakTriggered = false;
                this.mHandler.notifyNetworkResume();
            }
        } else {
            this.mHandler.notifyNetworkWeak();
            this.networkWeakTriggered = true;
        }
    }

    public void onGetArgbFrame(int[] data, int width, int height, Rect boundingBox) {
        AtomicInteger videoFrameCacheNumber = this.flvMuxer.getVideoFrameCacheNumber();
        if (videoFrameCacheNumber != null && videoFrameCacheNumber.get() < 30) {
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            if (this.useSoftEncoder) {
                throw new UnsupportedOperationException("Not implemented");
            }
            byte[] processedData = this.hwArgbFrameScaled(data, width, height, boundingBox);
            if (processedData != null) {
                this.onProcessedYuvFrame(processedData, pts);
            } else {
                this.mHandler.notifyEncodeIllegalArgumentException(new IllegalArgumentException("libyuv failure"));
            }
            if (this.networkWeakTriggered) {
                this.networkWeakTriggered = false;
                this.mHandler.notifyNetworkResume();
            }
        } else {
            this.mHandler.notifyNetworkWeak();
            this.networkWeakTriggered = true;
        }
    }

    public void onGetArgbFrame(int[] data, int width, int height) {
        AtomicInteger videoFrameCacheNumber = this.flvMuxer.getVideoFrameCacheNumber();
        if (videoFrameCacheNumber != null && videoFrameCacheNumber.get() < 30) {
            long pts = System.nanoTime() / 1000L - this.mPresentTimeUs;
            if (this.useSoftEncoder) {
                throw new UnsupportedOperationException("Not implemented");
            }
            byte[] processedData = this.hwArgbFrame(data, width, height);
            if (processedData != null) {
                this.onProcessedYuvFrame(processedData, pts);
            } else {
                this.mHandler.notifyEncodeIllegalArgumentException(new IllegalArgumentException("libyuv failure"));
            }
            if (this.networkWeakTriggered) {
                this.networkWeakTriggered = false;
                this.mHandler.notifyNetworkResume();
            }
        } else {
            this.mHandler.notifyNetworkWeak();
            this.networkWeakTriggered = true;
        }
    }

    private byte[] hwRgbaFrame(byte[] data, int width, int height) {
        switch (this.mVideoColorFormat) {
            case 19: {
                return this.RGBAToI420(data, width, height, true, 180);
            }
            case 21: {
                return this.RGBAToNV12(data, width, height, true, 180);
            }
        }
        throw new IllegalStateException("Unsupported color format!");
    }

    private byte[] hwYUVNV21FrameScaled(byte[] data, int width, int height, Rect boundingBox) {
        switch (this.mVideoColorFormat) {
            case 19: {
                return this.NV21ToI420Scaled(data, width, height, true, 180, boundingBox.left, boundingBox.top, boundingBox.width(), boundingBox.height());
            }
            case 21: {
                return this.NV21ToNV12Scaled(data, width, height, true, 180, boundingBox.left, boundingBox.top, boundingBox.width(), boundingBox.height());
            }
        }
        throw new IllegalStateException("Unsupported color format!");
    }

    private byte[] hwArgbFrameScaled(int[] data, int width, int height, Rect boundingBox) {
        switch (this.mVideoColorFormat) {
            case 19: {
                return this.ARGBToI420Scaled(data, width, height, false, 0, boundingBox.left, boundingBox.top, boundingBox.width(), boundingBox.height());
            }
            case 21: {
                return this.ARGBToNV12Scaled(data, width, height, false, 0, boundingBox.left, boundingBox.top, boundingBox.width(), boundingBox.height());
            }
        }
        throw new IllegalStateException("Unsupported color format!");
    }

    private byte[] hwArgbFrame(int[] data, int inputWidth, int inputHeight) {
        switch (this.mVideoColorFormat) {
            case 19: {
                return this.ARGBToI420(data, inputWidth, inputHeight, false, 0);
            }
            case 21: {
                return this.ARGBToNV12(data, inputWidth, inputHeight, false, 0);
            }
        }
        throw new IllegalStateException("Unsupported color format!");
    }

    private void swRgbaFrame(byte[] data, int width, int height, long pts) {
        this.RGBASoftEncode(data, width, height, true, 180, pts);
    }

    @SuppressLint(value={"MissingPermission"})
    public AudioRecord chooseAudioRecord() {
        AudioRecord mic = new AudioRecord(7, 44100, 12, 2, this.getPcmBufferSize() * 4);
        if (mic.getState() != 1) {
            mic = new AudioRecord(7, 44100, 16, 2, this.getPcmBufferSize() * 4);
            if (mic.getState() != 1) {
                mic = null;
            } else {
                aChannelConfig = 16;
            }
        } else {
            aChannelConfig = 12;
        }
        return mic;
    }

    private int getPcmBufferSize() {
        int pcmBufSize = AudioRecord.getMinBufferSize((int)44100, (int)12, (int)2) + 8191;
        return pcmBufSize - pcmBufSize % 8192;
    }

    private MediaCodecInfo chooseVideoEncoder(String name) {
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        int nbCodecs = mediaCodecList.getCodecInfos().length;
        for (int i = 0; i < nbCodecs; ++i) {
            MediaCodecInfo mci = mediaCodecList.getCodecInfos()[i];
            if (!mci.isEncoder()) continue;
            String[] types = mci.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(VCODEC)) continue;
                AmityLog.INSTANCE.tag(TAG).i(String.format("vencoder %s types: %s", mci.getName(), types[j]), new Object[0]);
                if (name != null) continue;
                return mci;
            }
        }
        return null;
    }

    private int chooseVideoEncoder() {
        int i;
        this.vmci = this.chooseVideoEncoder(null);
        int matchedColorFormat = 0;
        MediaCodecInfo.CodecCapabilities cc = this.vmci.getCapabilitiesForType(VCODEC);
        for (i = 0; i < cc.colorFormats.length; ++i) {
            int cf = cc.colorFormats[i];
            AmityLog.INSTANCE.tag(TAG).i(String.format("vencoder %s supports color fomart 0x%x(%d)", this.vmci.getName(), cf, cf), new Object[0]);
            if (cf < 19) continue;
            if (cf > 21) continue;
            return cf;
        }
        for (i = 0; i < cc.profileLevels.length; ++i) {
            MediaCodecInfo.CodecProfileLevel pl = cc.profileLevels[i];
            AmityLog.INSTANCE.tag(TAG).i(String.format("vencoder %s support profile %d, level %d", this.vmci.getName(), pl.profile, pl.level), new Object[0]);
        }
        AmityLog.INSTANCE.tag(TAG).i(String.format("vencoder %s choose color format 0x%x(%d)", this.vmci.getName(), matchedColorFormat, matchedColorFormat), new Object[0]);
        return matchedColorFormat;
    }

    private native void setEncoderResolution(int var1, int var2);

    private native void setEncoderFps(int var1);

    private native void setEncoderGop(int var1);

    private native void setEncoderBitrate(int var1);

    private native void setEncoderPreset(String var1);

    private native byte[] RGBAToI420(byte[] var1, int var2, int var3, boolean var4, int var5);

    private native byte[] RGBAToNV12(byte[] var1, int var2, int var3, boolean var4, int var5);

    private native byte[] ARGBToI420Scaled(int[] var1, int var2, int var3, boolean var4, int var5, int var6, int var7, int var8, int var9);

    private native byte[] ARGBToNV12Scaled(int[] var1, int var2, int var3, boolean var4, int var5, int var6, int var7, int var8, int var9);

    private native byte[] ARGBToI420(int[] var1, int var2, int var3, boolean var4, int var5);

    private native byte[] ARGBToNV12(int[] var1, int var2, int var3, boolean var4, int var5);

    private native byte[] NV21ToNV12Scaled(byte[] var1, int var2, int var3, boolean var4, int var5, int var6, int var7, int var8, int var9);

    private native byte[] NV21ToI420Scaled(byte[] var1, int var2, int var3, boolean var4, int var5, int var6, int var7, int var8, int var9);

    private native int RGBASoftEncode(byte[] var1, int var2, int var3, boolean var4, int var5, long var6);

    private native boolean openSoftEncoder();

    private native void closeSoftEncoder();

    static {
        System.loadLibrary("yuv");
        System.loadLibrary("enc");
    }
}

