/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.base.gpuimage;

import android.opengl.GLES20;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import net.ossrs.yasea.R;

public class GPUImageExposureFilter
extends GPUImageFilter {
    public static final String EXPOSURE_FRAGMENT_SHADER = " varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform highp float exposure;\n \n void main()\n {\n     highp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4(textureColor.rgb * pow(2.0, exposure), textureColor.w);\n } ";
    private int mExposureLocation;
    private float mExposure;

    public GPUImageExposureFilter() {
        this(0.0f);
    }

    public GPUImageExposureFilter(float exposure) {
        super(MagicFilterType.EXPOSURE, R.raw.exposure);
        this.mExposure = exposure;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mExposureLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"exposure");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setExposure(this.mExposure);
    }

    public void setExposure(float exposure) {
        this.mExposure = exposure;
        this.setFloat(this.mExposureLocation, this.mExposure);
    }
}

