/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp;

import com.amity.socialcloud.sdk.log.AmityLog;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final String TAG = "Crypto";
    private Mac hmacSHA256;

    public Crypto() {
        try {
            this.hmacSHA256 = Mac.getInstance("HmacSHA256");
        }
        catch (SecurityException e) {
            AmityLog.INSTANCE.tag(TAG).e("Security exception when getting HMAC", new Object[]{e});
        }
        catch (NoSuchAlgorithmException e) {
            AmityLog.INSTANCE.tag(TAG).e("HMAC SHA256 does not exist", new Object[0]);
        }
    }

    public byte[] calculateHmacSHA256(byte[] input, byte[] key) {
        byte[] output = null;
        try {
            this.hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            output = this.hmacSHA256.doFinal(input);
        }
        catch (InvalidKeyException e) {
            AmityLog.INSTANCE.tag(TAG).e("Invalid key", new Object[]{e});
        }
        return output;
    }

    public byte[] calculateHmacSHA256(byte[] input, byte[] key, int length) {
        byte[] output = null;
        try {
            this.hmacSHA256.init(new SecretKeySpec(key, 0, length, "HmacSHA256"));
            output = this.hmacSHA256.doFinal(input);
        }
        catch (InvalidKeyException e) {
            AmityLog.INSTANCE.tag(TAG).e("Invalid key", new Object[]{e});
        }
        return output;
    }
}

