/*
 * Decompiled with CFR 0.152.
 */
package com.amity.coremedia.iso.boxes;

import com.amity.coremedia.iso.BoxParser;
import com.amity.coremedia.iso.ChannelHelper;
import com.amity.coremedia.iso.IsoTypeWriter;
import com.amity.coremedia.iso.boxes.Box;
import com.amity.coremedia.iso.boxes.ContainerBox;
import com.amity.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;

public class FreeBox
implements Box {
    public static final String TYPE = "free";
    ByteBuffer data;
    List<Box> replacers = new LinkedList<Box>();
    private ContainerBox parent;

    public FreeBox() {
    }

    public FreeBox(int size) {
        this.data = ByteBuffer.allocate(size);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        for (Box replacer : this.replacers) {
            replacer.getBox(os);
        }
        ByteBuffer header = ByteBuffer.allocate(8);
        IsoTypeWriter.writeUInt32(header, 8 + this.data.limit());
        header.put(TYPE.getBytes());
        header.rewind();
        os.write(header);
        this.data.rewind();
        os.write(this.data);
    }

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    @Override
    public long getSize() {
        long size = 8L;
        for (Box replacer : this.replacers) {
            size += replacer.getSize();
        }
        return size += (long)this.data.limit();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        if (readableByteChannel instanceof FileChannel && contentSize > 0x100000L) {
            this.data = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), contentSize);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + contentSize);
        } else {
            assert (contentSize < Integer.MAX_VALUE);
            this.data = ChannelHelper.readFully(readableByteChannel, contentSize);
        }
    }

    public void addAndReplace(Box box) {
        this.data.position(CastUtils.l2i(box.getSize()));
        this.data = this.data.slice();
        this.replacers.add(box);
    }
}

