/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.advanced;

import android.opengl.GLES20;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import com.amity.seu.magicfilter.utils.OpenGLUtils;
import net.ossrs.yasea.R;

public class MagicFreudFilter
extends GPUImageFilter {
    private int mTexelHeightUniformLocation;
    private int mTexelWidthUniformLocation;
    private int[] inputTextureHandles = new int[]{-1};
    private int[] inputTextureUniformLocations = new int[]{-1};
    private int mGLStrengthLocation;

    public MagicFreudFilter() {
        super(MagicFilterType.FREUD, R.raw.freud);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        GLES20.glDeleteTextures((int)1, (int[])this.inputTextureHandles, (int)0);
        for (int i = 0; i < this.inputTextureHandles.length; ++i) {
            this.inputTextureHandles[i] = -1;
        }
    }

    @Override
    protected void onDrawArraysAfter() {
        for (int i = 0; i < this.inputTextureHandles.length && this.inputTextureHandles[i] != -1; ++i) {
            GLES20.glActiveTexture((int)(33984 + (i + 3)));
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glActiveTexture((int)33984);
        }
    }

    @Override
    protected void onDrawArraysPre() {
        for (int i = 0; i < this.inputTextureHandles.length && this.inputTextureHandles[i] != -1; ++i) {
            GLES20.glActiveTexture((int)(33984 + (i + 3)));
            GLES20.glBindTexture((int)3553, (int)this.inputTextureHandles[i]);
            GLES20.glUniform1i((int)this.inputTextureUniformLocations[i], (int)(i + 3));
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.inputTextureUniformLocations[0] = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputImageTexture2");
        this.mTexelWidthUniformLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputImageTextureWidth");
        this.mTexelHeightUniformLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputImageTextureHeight");
        this.mGLStrengthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"strength");
    }

    @Override
    protected void onInitialized() {
        super.onInitialized();
        this.setFloat(this.mGLStrengthLocation, 1.0f);
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                ((MagicFreudFilter)MagicFreudFilter.this).inputTextureHandles[0] = OpenGLUtils.loadTexture(MagicFreudFilter.this.getContext(), "filter/freud_rand.png");
            }
        });
    }

    @Override
    public void onInputSizeChanged(int width, int height) {
        super.onInputSizeChanged(width, height);
        GLES20.glUniform1f((int)this.mTexelWidthUniformLocation, (float)width);
        GLES20.glUniform1f((int)this.mTexelHeightUniformLocation, (float)height);
    }
}

