/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video;

import android.content.Context;
import android.hardware.Camera;
import com.amity.github.faucamp.simplertmp.RtmpHandler;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.video.AmityCameraView;
import com.amity.socialcloud.sdk.video.AmityStreamBroadcaster;
import com.amity.socialcloud.sdk.video.AmityStreamBroadcasterConfiguration;
import com.amity.socialcloud.sdk.video.StreamBroadcaster;
import com.amity.socialcloud.sdk.video.domain.CreateVideoStreamingUC;
import com.amity.socialcloud.sdk.video.domain.DisposeVideoStreamingUC;
import com.amity.socialcloud.sdk.video.domain.GetVideoStreamingUC;
import com.amity.socialcloud.sdk.video.listener.DefaultEncodeHandlerListener;
import com.amity.socialcloud.sdk.video.listener.DefaultRecordHandlerListener;
import com.amity.socialcloud.sdk.video.listener.EkoRtmpListener;
import com.amity.socialcloud.sdk.video.model.AmityBroadcasterData;
import com.amity.socialcloud.sdk.video.model.AmityStreamBroadcasterState;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.operators.single.SingleTimer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ossrs.yasea.SrsEncodeHandler;
import net.ossrs.yasea.SrsPublisher;
import net.ossrs.yasea.SrsRecordHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcaster;", "Lcom/amity/socialcloud/sdk/video/StreamBroadcaster;", "srsPublisher", "Lnet/ossrs/yasea/SrsPublisher;", "(Lnet/ossrs/yasea/SrsPublisher;)V", "broadcasterData", "Lcom/amity/socialcloud/sdk/video/model/AmityBroadcasterData;", "configuration", "Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcasterConfiguration;", "isCameraStart", "", "getStateFlowable", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/video/model/AmityStreamBroadcasterState;", "pausePublish", "", "refreshCamera", "resumePublish", "startAudio", "startPreview", "startPublish", "streamId", "", "startPublishNewStream", "title", "description", "stopAudio", "stopPublish", "switchCamera", "updateConfiguration", "Builder", "amity-video-publisher_release"})
public final class AmityStreamBroadcaster
implements StreamBroadcaster {
    private AmityBroadcasterData broadcasterData;
    private boolean isCameraStart;
    private AmityStreamBroadcasterConfiguration configuration;
    private final SrsPublisher srsPublisher;

    @Override
    public void startPreview() {
        if (!this.isCameraStart) {
            this.isCameraStart = true;
            new SingleTimer(300L, TimeUnit.MILLISECONDS, AndroidSchedulers.mainThread()).doOnSuccess((Consumer)new Consumer<Long>(this){
                final /* synthetic */ AmityStreamBroadcaster this$0;

                public final void accept(Long it) {
                    AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).startCamera();
                }
                {
                    this.this$0 = amityStreamBroadcaster;
                }
            }).subscribe();
        }
    }

    @Override
    public void startPublishNewStream(@NotNull String title, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        CreateVideoStreamingUC createVideoStreamingUC = new CreateVideoStreamingUC();
        AmityStreamBroadcasterConfiguration amityStreamBroadcasterConfiguration = this.configuration;
        if (amityStreamBroadcasterConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        }
        CreateVideoStreamingUC.execute$default(createVideoStreamingUC, title, description, amityStreamBroadcasterConfiguration.getResolution(), null, 8, null).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<AmityBroadcasterData>(this){
            final /* synthetic */ AmityStreamBroadcaster this$0;

            public final void accept(AmityBroadcasterData it) {
                AmityStreamBroadcaster.access$setBroadcasterData$p(this.this$0, it);
                AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).startPublish(it.getBroadcastingUrl());
            }
            {
                this.this$0 = amityStreamBroadcaster;
            }
        }, (Consumer)startPublishNewStream.2.INSTANCE);
    }

    @Override
    public void startPublish(@NotNull String streamId) {
        Intrinsics.checkParameterIsNotNull((Object)streamId, (String)"streamId");
        new GetVideoStreamingUC().execute(streamId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PartialStreamData>(this){
            final /* synthetic */ AmityStreamBroadcaster this$0;

            public final void accept(PartialStreamData it) {
                AmityStreamBroadcaster.access$setBroadcasterData$p(this.this$0, new AmityBroadcasterData(it.getStreamId(), it.getBroadcastingUrl()));
                AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).startPublish(it.getBroadcastingUrl());
            }
            {
                this.this$0 = amityStreamBroadcaster;
            }
        }, (Consumer)startPublish.2.INSTANCE);
    }

    @Override
    public void switchCamera() {
        this.srsPublisher.switchCameraFace((this.srsPublisher.getCameraId() + 1) % Camera.getNumberOfCameras());
    }

    @Override
    public void stopPublish() {
        block0: {
            this.srsPublisher.stopPublish();
            AmityBroadcasterData amityBroadcasterData = this.broadcasterData;
            if (amityBroadcasterData == null) break block0;
            AmityBroadcasterData amityBroadcasterData2 = amityBroadcasterData;
            boolean bl = false;
            boolean bl2 = false;
            AmityBroadcasterData it = amityBroadcasterData2;
            boolean bl3 = false;
            new DisposeVideoStreamingUC().execute(it.getStreamId());
        }
    }

    @Override
    public void startAudio() {
        this.srsPublisher.startAudio();
    }

    @Override
    public void stopAudio() {
        this.srsPublisher.stopAudio();
    }

    @Override
    public void pausePublish() {
        this.isCameraStart = false;
        this.srsPublisher.stopPublish();
    }

    @Override
    public void resumePublish() {
        AmityBroadcasterData amityBroadcasterData = this.broadcasterData;
        if (amityBroadcasterData == null) {
            Intrinsics.throwNpe();
        }
        this.srsPublisher.startPublish(amityBroadcasterData.getBroadcastingUrl());
    }

    @Override
    @NotNull
    public Flowable<AmityStreamBroadcasterState> getStateFlowable() {
        Flowable flowable = this.srsPublisher.getStatusSubject().toFlowable(BackpressureStrategy.BUFFER);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"srsPublisher.statusSubje\u2026kpressureStrategy.BUFFER)");
        return flowable;
    }

    @Override
    public void updateConfiguration(@NotNull AmityStreamBroadcasterConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.srsPublisher.setOutputResolution(configuration.getResolution());
        this.srsPublisher.setVideoBitrate(configuration.getResolution());
        this.refreshCamera();
    }

    private final void refreshCamera() {
        new SingleTimer(300L, TimeUnit.MILLISECONDS, AndroidSchedulers.mainThread()).doOnSuccess((Consumer)new Consumer<Long>(this){
            final /* synthetic */ AmityStreamBroadcaster this$0;

            public final void accept(Long it) {
                AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).switchCameraFace(AmityStreamBroadcaster.access$getSrsPublisher$p(this.this$0).getCameraId());
            }
            {
                this.this$0 = amityStreamBroadcaster;
            }
        }).subscribe();
    }

    private AmityStreamBroadcaster(SrsPublisher srsPublisher) {
        this.srsPublisher = srsPublisher;
    }

    public /* synthetic */ AmityStreamBroadcaster(SrsPublisher srsPublisher, DefaultConstructorMarker $constructor_marker) {
        this(srsPublisher);
    }

    public static final /* synthetic */ SrsPublisher access$getSrsPublisher$p(AmityStreamBroadcaster $this) {
        return $this.srsPublisher;
    }

    public static final /* synthetic */ AmityBroadcasterData access$getBroadcasterData$p(AmityStreamBroadcaster $this) {
        return $this.broadcasterData;
    }

    public static final /* synthetic */ void access$setBroadcasterData$p(AmityStreamBroadcaster $this, AmityBroadcasterData amityBroadcasterData) {
        $this.broadcasterData = amityBroadcasterData;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcaster$Builder;", "", "amityCameraView", "Lcom/amity/socialcloud/sdk/video/AmityCameraView;", "(Lcom/amity/socialcloud/sdk/video/AmityCameraView;)V", "configuration", "Lcom/amity/socialcloud/sdk/video/AmityStreamBroadcasterConfiguration;", "statusSubject", "Lio/reactivex/subjects/PublishSubject;", "Lcom/amity/socialcloud/sdk/video/model/AmityStreamBroadcasterState;", "build", "Lcom/amity/socialcloud/sdk/video/StreamBroadcaster;", "setConfiguration", "amity-video-publisher_release"})
    public static final class Builder {
        private AmityStreamBroadcasterConfiguration configuration;
        private PublishSubject<AmityStreamBroadcasterState> statusSubject;
        private final AmityCameraView amityCameraView;

        @NotNull
        public final Builder setConfiguration(@NotNull AmityStreamBroadcasterConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.configuration = configuration;
            return builder;
        }

        @NotNull
        public final StreamBroadcaster build() {
            SrsPublisher publisher = new SrsPublisher(this.amityCameraView, this.statusSubject);
            publisher.setEncodeHandler(new SrsEncodeHandler(new DefaultEncodeHandlerListener()));
            publisher.setRecordHandler(new SrsRecordHandler(new DefaultRecordHandlerListener()));
            publisher.setPreviewResolution(this.configuration.getResolution());
            AmityStreamBroadcaster broadcaster = new AmityStreamBroadcaster(publisher, null);
            broadcaster.updateConfiguration(this.configuration);
            Context context = this.amityCameraView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"amityCameraView.context");
            EkoRtmpListener rtmpListener = new EkoRtmpListener(context, broadcaster, this.statusSubject);
            publisher.setRtmpHandler(new RtmpHandler(rtmpListener));
            return broadcaster;
        }

        public Builder(@NotNull AmityCameraView amityCameraView) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)amityCameraView), (String)"amityCameraView");
            this.amityCameraView = amityCameraView;
            this.configuration = new AmityStreamBroadcasterConfiguration.Builder().build();
            PublishSubject publishSubject = PublishSubject.create();
            Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create()");
            this.statusSubject = publishSubject;
        }
    }
}

