/*
 * Decompiled with CFR 0.152.
 */
package com.amity.seu.magicfilter.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;

public class OpenGLUtils {
    public static final int NO_TEXTURE = -1;
    public static final int NOT_INIT = -1;
    public static final int ON_DRAWN = 1;

    public static int loadTexture(Bitmap img, int usedTexId) {
        return OpenGLUtils.loadTexture(img, usedTexId, false);
    }

    public static int loadTexture(Bitmap img, int usedTexId, boolean recyled) {
        if (img == null) {
            return -1;
        }
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)img, (int)0);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)img);
            textures[0] = usedTexId;
        }
        if (recyled) {
            img.recycle();
        }
        return textures[0];
    }

    public static int loadTexture(Buffer data, int width, int height, int usedTexId) {
        if (data == null) {
            return -1;
        }
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)data);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)data);
            textures[0] = usedTexId;
        }
        return textures[0];
    }

    public static int loadTexture(Buffer data, int width, int height, int usedTexId, int type) {
        if (data == null) {
            return -1;
        }
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)type, (Buffer)data);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)type, (Buffer)data);
            textures[0] = usedTexId;
        }
        return textures[0];
    }

    public static int loadTexture(Context context, String name) {
        int[] textureHandle = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandle, (int)0);
        if (textureHandle[0] != 0) {
            Bitmap bitmap = OpenGLUtils.getImageFromAssetsFile(context, name);
            GLES20.glBindTexture((int)3553, (int)textureHandle[0]);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            bitmap.recycle();
        }
        if (textureHandle[0] == 0) {
            throw new RuntimeException("Error loading texture.");
        }
        return textureHandle[0];
    }

    private static Bitmap getImageFromAssetsFile(Context context, String fileName) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        try {
            InputStream is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static int loadProgram(String strVSource, String strFSource) {
        int[] link = new int[1];
        int iVShader = OpenGLUtils.loadShader(strVSource, 35633);
        if (iVShader == 0) {
            Log.d((String)"Load Program", (String)"Vertex Shader Failed");
            return 0;
        }
        int iFShader = OpenGLUtils.loadShader(strFSource, 35632);
        if (iFShader == 0) {
            Log.d((String)"Load Program", (String)"Fragment Shader Failed");
            return 0;
        }
        int iProgId = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)iProgId, (int)iVShader);
        GLES20.glAttachShader((int)iProgId, (int)iFShader);
        GLES20.glLinkProgram((int)iProgId);
        GLES20.glGetProgramiv((int)iProgId, (int)35714, (int[])link, (int)0);
        if (link[0] <= 0) {
            Log.d((String)"Load Program", (String)"Linking Failed");
            return 0;
        }
        GLES20.glDeleteShader((int)iVShader);
        GLES20.glDeleteShader((int)iFShader);
        return iProgId;
    }

    private static int loadShader(String strSource, int iType) {
        int[] compiled = new int[1];
        int iShader = GLES20.glCreateShader((int)iType);
        GLES20.glShaderSource((int)iShader, (String)strSource);
        GLES20.glCompileShader((int)iShader);
        GLES20.glGetShaderiv((int)iShader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)"Load Shader Failed", (String)("Compilation\n" + GLES20.glGetShaderInfoLog((int)iShader)));
            return 0;
        }
        return iShader;
    }

    public static int getExternalOESTextureID() {
        int[] texture = new int[1];
        GLES20.glGenTextures((int)1, (int[])texture, (int)0);
        GLES20.glBindTexture((int)36197, (int)texture[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return texture[0];
    }

    public static String readShaderFromRawResource(Context context, int resourceId) {
        InputStream inputStream = context.getResources().openRawResource(resourceId);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder body = new StringBuilder();
        try {
            String nextLine;
            while ((nextLine = bufferedReader.readLine()) != null) {
                body.append(nextLine);
                body.append('\n');
            }
        }
        catch (IOException e) {
            return null;
        }
        return body.toString();
    }
}

