/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp.io;

import android.util.Log;
import com.amity.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.amity.github.faucamp.simplertmp.io.RtmpSessionInfo;
import com.amity.github.faucamp.simplertmp.packets.Abort;
import com.amity.github.faucamp.simplertmp.packets.Acknowledgement;
import com.amity.github.faucamp.simplertmp.packets.Audio;
import com.amity.github.faucamp.simplertmp.packets.Command;
import com.amity.github.faucamp.simplertmp.packets.Data;
import com.amity.github.faucamp.simplertmp.packets.RtmpHeader;
import com.amity.github.faucamp.simplertmp.packets.RtmpPacket;
import com.amity.github.faucamp.simplertmp.packets.SetChunkSize;
import com.amity.github.faucamp.simplertmp.packets.SetPeerBandwidth;
import com.amity.github.faucamp.simplertmp.packets.UserControl;
import com.amity.github.faucamp.simplertmp.packets.Video;
import com.amity.github.faucamp.simplertmp.packets.WindowAckSize;
import java.io.IOException;
import java.io.InputStream;

public class RtmpDecoder {
    private static final String TAG = "RtmpDecoder";
    private RtmpSessionInfo rtmpSessionInfo;

    public RtmpDecoder(RtmpSessionInfo rtmpSessionInfo) {
        this.rtmpSessionInfo = rtmpSessionInfo;
    }

    public RtmpPacket readPacket(InputStream in) throws IOException {
        RtmpPacket rtmpPacket;
        RtmpHeader header = RtmpHeader.readHeader(in, this.rtmpSessionInfo);
        ChunkStreamInfo chunkStreamInfo = this.rtmpSessionInfo.getChunkStreamInfo(header.getChunkStreamId());
        chunkStreamInfo.setPrevHeaderRx(header);
        if (header.getPacketLength() > this.rtmpSessionInfo.getRxChunkSize()) {
            if (!chunkStreamInfo.storePacketChunk(in, this.rtmpSessionInfo.getRxChunkSize())) {
                return null;
            }
            in = chunkStreamInfo.getStoredPacketInputStream();
        }
        switch (header.getMessageType()) {
            case SET_CHUNK_SIZE: {
                SetChunkSize setChunkSize = new SetChunkSize(header);
                setChunkSize.readBody(in);
                Log.d((String)TAG, (String)("readPacket(): Setting chunk size to: " + setChunkSize.getChunkSize()));
                this.rtmpSessionInfo.setRxChunkSize(setChunkSize.getChunkSize());
                return null;
            }
            case ABORT: {
                rtmpPacket = new Abort(header);
                break;
            }
            case USER_CONTROL_MESSAGE: {
                rtmpPacket = new UserControl(header);
                break;
            }
            case WINDOW_ACKNOWLEDGEMENT_SIZE: {
                rtmpPacket = new WindowAckSize(header);
                break;
            }
            case SET_PEER_BANDWIDTH: {
                rtmpPacket = new SetPeerBandwidth(header);
                break;
            }
            case AUDIO: {
                rtmpPacket = new Audio(header);
                break;
            }
            case VIDEO: {
                rtmpPacket = new Video(header);
                break;
            }
            case COMMAND_AMF0: {
                rtmpPacket = new Command(header);
                break;
            }
            case DATA_AMF0: {
                rtmpPacket = new Data(header);
                break;
            }
            case ACKNOWLEDGEMENT: {
                rtmpPacket = new Acknowledgement(header);
                break;
            }
            default: {
                throw new IOException("No packet body implementation for message type: " + (Object)((Object)header.getMessageType()));
            }
        }
        rtmpPacket.readBody(in);
        return rtmpPacket;
    }
}

