/*
 * Decompiled with CFR 0.152.
 */
package com.amity.github.faucamp.simplertmp;

import android.util.Log;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final String TAG = "Crypto";
    private Mac hmacSHA256;

    public Crypto() {
        try {
            this.hmacSHA256 = Mac.getInstance("HmacSHA256");
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"Security exception when getting HMAC", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"HMAC SHA256 does not exist");
        }
    }

    public byte[] calculateHmacSHA256(byte[] input, byte[] key) {
        byte[] output = null;
        try {
            this.hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            output = this.hmacSHA256.doFinal(input);
        }
        catch (InvalidKeyException e) {
            Log.e((String)TAG, (String)"Invalid key", (Throwable)e);
        }
        return output;
    }

    public byte[] calculateHmacSHA256(byte[] input, byte[] key, int length) {
        byte[] output = null;
        try {
            this.hmacSHA256.init(new SecretKeySpec(key, 0, length, "HmacSHA256"));
            output = this.hmacSHA256.doFinal(input);
        }
        catch (InvalidKeyException e) {
            Log.e((String)TAG, (String)"Invalid key", (Throwable)e);
        }
        return output;
    }
}

