/*
 * Decompiled with CFR 0.152.
 */
package net.ossrs.yasea;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.util.AttributeSet;
import com.amity.seu.magicfilter.base.gpuimage.GPUImageFilter;
import com.amity.seu.magicfilter.utils.MagicFilterFactory;
import com.amity.seu.magicfilter.utils.MagicFilterType;
import com.amity.seu.magicfilter.utils.OpenGLUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class SrsCameraView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private GPUImageFilter magicFilter;
    private SurfaceTexture surfaceTexture;
    private int mOESTextureId = -1;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mPreviewWidth;
    private int mPreviewHeight;
    private volatile boolean mIsEncoding;
    private boolean mIsTorchOn = false;
    private float mInputAspectRatio;
    private float mOutputAspectRatio;
    private float[] mProjectionMatrix = new float[16];
    private float[] mSurfaceMatrix = new float[16];
    private float[] mTransformMatrix = new float[16];
    private Camera mCamera;
    private ByteBuffer mGLPreviewBuffer;
    private int mCamId = -1;
    private int mPreviewRotation = 90;
    private int mPreviewOrientation = 1;
    private Thread worker;
    private final Object writeLock = new Object();
    private ConcurrentLinkedQueue<IntBuffer> mGLIntBufferCache = new ConcurrentLinkedQueue();
    private PreviewCallback mPrevCb;
    private CameraCallbacksHandler cameraCallbacksHandler = new CameraCallbacksHandler();
    public static final int VFPS = 30;

    public SrsCameraView(Context context) {
        this(context, null);
    }

    public SrsCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        GLES20.glDisable((int)3024);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.magicFilter = new GPUImageFilter(MagicFilterType.NONE);
        this.magicFilter.init(this.getContext().getApplicationContext());
        this.magicFilter.onInputSizeChanged(this.mPreviewWidth, this.mPreviewHeight);
        this.mOESTextureId = OpenGLUtils.getExternalOESTextureID();
        this.surfaceTexture = new SurfaceTexture(this.mOESTextureId);
        this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                SrsCameraView.this.requestRender();
            }
        });
        if (this.mCamera != null) {
            try {
                this.mCamera.getParameters().getSupportedPreviewSizes();
                this.mCamera.setPreviewTexture(this.surfaceTexture);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        this.magicFilter.onDisplaySizeChanged(width, height);
        this.magicFilter.onInputSizeChanged(this.mPreviewWidth, this.mPreviewHeight);
        this.mOutputAspectRatio = width > height ? (float)width / (float)height : (float)height / (float)width;
        float aspectRatio = this.mOutputAspectRatio / this.mInputAspectRatio;
        if (width > height) {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-aspectRatio), (float)aspectRatio, (float)-1.0f, (float)1.0f);
        } else {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)(-aspectRatio), (float)aspectRatio, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        this.surfaceTexture.updateTexImage();
        this.surfaceTexture.getTransformMatrix(this.mSurfaceMatrix);
        Matrix.multiplyMM((float[])this.mTransformMatrix, (int)0, (float[])this.mSurfaceMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        this.magicFilter.setTextureTransformMatrix(this.mTransformMatrix);
        this.magicFilter.onDrawFrame(this.mOESTextureId);
        if (this.mIsEncoding) {
            this.mGLIntBufferCache.add(this.magicFilter.getGLFboBuffer());
            Object object = this.writeLock;
            synchronized (object) {
                this.writeLock.notifyAll();
            }
        }
    }

    public void setPreviewCallback(PreviewCallback cb) {
        this.mPrevCb = cb;
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public void setPreviewCallback(Camera.PreviewCallback previewCallback) {
        this.mCamera.setPreviewCallback(previewCallback);
    }

    public int[] setPreviewResolution(int width, int height) {
        this.mCamera = this.openCamera();
        this.mPreviewWidth = width;
        this.mPreviewHeight = height;
        if (this.mCamera != null) {
            Camera camera = this.mCamera;
            Objects.requireNonNull(camera);
            Camera.Size rs = this.adaptPreviewResolution(new Camera.Size(camera, width, height));
            if (rs != null) {
                this.mPreviewWidth = rs.width;
                this.mPreviewHeight = rs.height;
            }
            this.setZOrderMediaOverlay(false);
            this.mCamera.getParameters().setPreviewSize(this.mPreviewWidth, this.mPreviewHeight);
            if (this.mGLPreviewBuffer != null) {
                this.mGLPreviewBuffer.clear();
            }
            this.mInputAspectRatio = this.mPreviewWidth > this.mPreviewHeight ? (float)this.mPreviewWidth / (float)this.mPreviewHeight : (float)this.mPreviewHeight / (float)this.mPreviewWidth;
        }
        return new int[]{this.mPreviewWidth, this.mPreviewHeight};
    }

    public boolean setFilter(final MagicFilterType type) {
        if (this.mCamera == null) {
            return false;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (SrsCameraView.this.magicFilter != null) {
                    SrsCameraView.this.magicFilter.destroy();
                }
                SrsCameraView.this.magicFilter = MagicFilterFactory.initFilters(type);
                if (SrsCameraView.this.magicFilter != null) {
                    SrsCameraView.this.magicFilter.init(SrsCameraView.this.getContext().getApplicationContext());
                    SrsCameraView.this.magicFilter.onInputSizeChanged(SrsCameraView.this.mPreviewWidth, SrsCameraView.this.mPreviewHeight);
                    SrsCameraView.this.magicFilter.onDisplaySizeChanged(SrsCameraView.this.mSurfaceWidth, SrsCameraView.this.mSurfaceHeight);
                }
            }
        });
        this.requestRender();
        return true;
    }

    private void deleteTextures() {
        if (this.mOESTextureId != -1) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{SrsCameraView.this.mOESTextureId}, (int)0);
                    SrsCameraView.this.mOESTextureId = -1;
                }
            });
        }
    }

    public void setCameraId(int id) {
        this.stopTorch();
        this.mCamId = id;
        this.setPreviewOrientation(this.mPreviewOrientation);
    }

    protected int getRotateDeg() {
        try {
            int rotate = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getRotation();
            switch (rotate) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 90;
                }
                case 2: {
                    return 180;
                }
                case 3: {
                    return 270;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public void setPreviewOrientation(int orientation) {
        this.mPreviewOrientation = orientation;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCamId, (Camera.CameraInfo)info);
        int rotateDeg = this.getRotateDeg();
        if (orientation == 1) {
            if (info.facing == 1) {
                this.mPreviewRotation = info.orientation % 360;
                this.mPreviewRotation = (360 - this.mPreviewRotation) % 360;
            } else {
                this.mPreviewRotation = (info.orientation + 360) % 360;
            }
        } else if (orientation == 2) {
            if (info.facing == 1) {
                this.mPreviewRotation = (info.orientation - 90) % 360;
                this.mPreviewRotation = (360 - this.mPreviewRotation) % 360;
            } else {
                this.mPreviewRotation = (info.orientation + 90) % 360;
            }
        }
        if (rotateDeg > 0) {
            this.mPreviewRotation %= rotateDeg;
        }
    }

    public int getCameraId() {
        return this.mCamId;
    }

    public void enableEncoding() {
        this.mGLPreviewBuffer = ByteBuffer.allocate(this.mPreviewWidth * this.mPreviewHeight * 4);
        this.worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    IntBuffer picture;
                    while (!SrsCameraView.this.mGLIntBufferCache.isEmpty() && (picture = (IntBuffer)SrsCameraView.this.mGLIntBufferCache.poll()) != null) {
                        SrsCameraView.this.mGLPreviewBuffer.asIntBuffer().put(picture.array());
                        SrsCameraView.this.mPrevCb.onGetRgbaFrame(SrsCameraView.this.mGLPreviewBuffer.array(), SrsCameraView.this.mPreviewWidth, SrsCameraView.this.mPreviewHeight);
                    }
                    Object object = SrsCameraView.this.writeLock;
                    synchronized (object) {
                        try {
                            SrsCameraView.this.writeLock.wait(500L);
                        }
                        catch (InterruptedException ie) {
                            SrsCameraView.this.worker.interrupt();
                        }
                    }
                }
            }
        });
        this.worker.start();
        this.mIsEncoding = true;
    }

    public void disableEncoding() {
        this.mIsEncoding = false;
        if (this.mGLIntBufferCache != null) {
            this.mGLIntBufferCache.clear();
        }
        if (this.mGLPreviewBuffer != null) {
            this.mGLPreviewBuffer.clear();
        }
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.worker.interrupt();
            }
            this.worker = null;
        }
    }

    public boolean startCamera() {
        List supportedFlashModes;
        if (this.mCamera == null) {
            this.mCamera = this.openCamera();
            if (this.mCamera == null) {
                return false;
            }
        }
        Camera.Parameters params = this.mCamera.getParameters();
        params.setPreviewSize(this.mPreviewWidth, this.mPreviewHeight);
        int[] range = this.adaptFpsRange(30, params.getSupportedPreviewFpsRange());
        params.setPreviewFpsRange(range[0], range[1]);
        params.setPreviewFormat(17);
        params.setFlashMode("off");
        params.setWhiteBalance("auto");
        params.setSceneMode("auto");
        params.setRecordingHint(true);
        List supportedFocusModes = params.getSupportedFocusModes();
        if (supportedFocusModes != null && !supportedFocusModes.isEmpty()) {
            if (supportedFocusModes.contains("continuous-picture")) {
                params.setFocusMode("continuous-picture");
            } else if (supportedFocusModes.contains("auto")) {
                params.setFocusMode("auto");
                this.mCamera.autoFocus(null);
            } else {
                params.setFocusMode((String)supportedFocusModes.get(0));
            }
        }
        if ((supportedFlashModes = params.getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty()) {
            if (supportedFlashModes.contains("torch")) {
                if (this.mIsTorchOn) {
                    params.setFlashMode("torch");
                }
            } else {
                params.setFlashMode((String)supportedFlashModes.get(0));
            }
        }
        this.cameraCallbacksHandler.onCameraParameters(params);
        this.mCamera.setParameters(params);
        this.mCamera.setDisplayOrientation(this.mPreviewRotation);
        try {
            this.mCamera.setPreviewTexture(this.surfaceTexture);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mCamera.startPreview();
        return true;
    }

    public void stopCamera() {
        this.disableEncoding();
        this.stopTorch();
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    protected Camera openCamera() {
        Camera camera = null;
        if (this.mCamId < 0) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            int numCameras = Camera.getNumberOfCameras();
            int frontCamId = -1;
            int backCamId = -1;
            for (int i = 0; i < numCameras; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 0) {
                    backCamId = i;
                    continue;
                }
                if (info.facing != 1) continue;
                frontCamId = i;
                break;
            }
            this.mCamId = frontCamId != -1 ? frontCamId : (backCamId != -1 ? backCamId : 0);
        }
        try {
            camera = Camera.open((int)this.mCamId);
            camera.setErrorCallback(new Camera.ErrorCallback(){

                public void onError(int error, Camera camera) {
                    SrsCameraView.this.stopCamera();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return camera;
    }

    private Camera.Size adaptPreviewResolution(Camera.Size resolution) {
        float diff = 100.0f;
        float xdy = (float)resolution.width / (float)resolution.height;
        Camera.Size best = null;
        for (Camera.Size size : this.mCamera.getParameters().getSupportedPreviewSizes()) {
            if (size.equals((Object)resolution)) {
                return size;
            }
            float tmp = Math.abs((float)size.width / (float)size.height - xdy);
            if (!(tmp < diff)) continue;
            diff = tmp;
            best = size;
        }
        return best;
    }

    private int[] adaptFpsRange(int expectedFps, List<int[]> fpsRanges) {
        int[] closestRange = fpsRanges.get(0);
        int measure = Math.abs(closestRange[0] - (expectedFps *= 1000)) + Math.abs(closestRange[1] - expectedFps);
        for (int[] range : fpsRanges) {
            int curMeasure;
            if (range[0] > expectedFps || range[1] < expectedFps || (curMeasure = Math.abs(range[0] - expectedFps) + Math.abs(range[1] - expectedFps)) >= measure) continue;
            closestRange = range;
            measure = curMeasure;
        }
        return closestRange;
    }

    public boolean startTorch() {
        Camera.Parameters params;
        List supportedFlashModes;
        if (this.mCamera != null && (supportedFlashModes = (params = this.mCamera.getParameters()).getSupportedFlashModes()) != null && !supportedFlashModes.isEmpty() && supportedFlashModes.contains("torch")) {
            params.setFlashMode("torch");
            this.mCamera.setParameters(params);
            return true;
        }
        return false;
    }

    public void stopTorch() {
        if (this.mCamera != null) {
            try {
                Camera.Parameters params = this.mCamera.getParameters();
                params.setFlashMode("off");
                this.mCamera.setParameters(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCameraCallbacksHandler(CameraCallbacksHandler cameraCallbacksHandler) {
        this.cameraCallbacksHandler = cameraCallbacksHandler;
    }

    public static interface CameraCallbacks {
        public void onCameraParameters(Camera.Parameters var1);
    }

    public static class CameraCallbacksHandler
    implements CameraCallbacks {
        @Override
        public void onCameraParameters(Camera.Parameters params) {
        }
    }

    public static interface PreviewCallback {
        public void onGetRgbaFrame(byte[] var1, int var2, int var3);
    }
}

