/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.boxes.ultraviolet;

import com.amity.coremedia.iso.IsoTypeReader;
import com.amity.coremedia.iso.Utf8;
import com.amity.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public class AssetInformationBox
extends AbstractFullBox {
    String apid = "";
    String profileVersion = "0000";

    public AssetInformationBox() {
        super("ainf");
    }

    @Override
    protected long getContentSize() {
        return Utf8.utf8StringLengthInBytes(this.apid) + 9;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        byteBuffer.put(Utf8.convert(this.profileVersion), 0, 4);
        byteBuffer.put(Utf8.convert(this.apid));
        byteBuffer.put((byte)0);
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.profileVersion = IsoTypeReader.readString(content, 4);
        this.apid = IsoTypeReader.readString(content);
        content = null;
    }

    public String getApid() {
        return this.apid;
    }

    public void setApid(String apid) {
        this.apid = apid;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        assert (profileVersion != null && profileVersion.length() == 4);
        this.profileVersion = profileVersion;
    }
}

