/*
 * Decompiled with CFR 0.152.
 */
package com.amity.googlecode.mp4parser.authoring;

import com.amity.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.amity.coremedia.iso.boxes.CompositionTimeToSample;
import com.amity.coremedia.iso.boxes.MediaHeaderBox;
import com.amity.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.amity.coremedia.iso.boxes.SampleDescriptionBox;
import com.amity.coremedia.iso.boxes.SampleTableBox;
import com.amity.coremedia.iso.boxes.SubSampleInformationBox;
import com.amity.coremedia.iso.boxes.TimeToSampleBox;
import com.amity.coremedia.iso.boxes.TrackBox;
import com.amity.coremedia.iso.boxes.TrackHeaderBox;
import com.amity.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.amity.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.amity.coremedia.iso.boxes.fragment.SampleFlags;
import com.amity.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.amity.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.amity.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.amity.coremedia.iso.boxes.fragment.TrackRunBox;
import com.amity.coremedia.iso.boxes.mdat.SampleList;
import com.amity.googlecode.mp4parser.authoring.AbstractTrack;
import com.amity.googlecode.mp4parser.authoring.TrackMetaData;
import com.amity.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Mp4TrackImpl
extends AbstractTrack {
    private List<ByteBuffer> samples;
    private SampleDescriptionBox sampleDescriptionBox;
    private List<TimeToSampleBox.Entry> decodingTimeEntries;
    private List<CompositionTimeToSample.Entry> compositionTimeEntries;
    private long[] syncSamples = new long[0];
    private List<SampleDependencyTypeBox.Entry> sampleDependencies;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private String handler;
    private AbstractMediaHeaderBox mihd;

    public Mp4TrackImpl(TrackBox trackBox) {
        long trackId = trackBox.getTrackHeaderBox().getTrackId();
        this.samples = new SampleList(trackBox);
        SampleTableBox stbl = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        this.handler = trackBox.getMediaBox().getHandlerBox().getHandlerType();
        this.mihd = trackBox.getMediaBox().getMediaInformationBox().getMediaHeaderBox();
        this.decodingTimeEntries = new LinkedList<TimeToSampleBox.Entry>();
        this.compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
        this.sampleDependencies = new LinkedList<SampleDependencyTypeBox.Entry>();
        this.decodingTimeEntries.addAll(stbl.getTimeToSampleBox().getEntries());
        if (stbl.getCompositionTimeToSample() != null) {
            this.compositionTimeEntries.addAll(stbl.getCompositionTimeToSample().getEntries());
        }
        if (stbl.getSampleDependencyTypeBox() != null) {
            this.sampleDependencies.addAll(stbl.getSampleDependencyTypeBox().getEntries());
        }
        if (stbl.getSyncSampleBox() != null) {
            this.syncSamples = stbl.getSyncSampleBox().getSampleNumber();
        }
        this.sampleDescriptionBox = stbl.getSampleDescriptionBox();
        List<MovieExtendsBox> movieExtendsBoxes = trackBox.getParent().getBoxes(MovieExtendsBox.class);
        if (movieExtendsBoxes.size() > 0) {
            for (MovieExtendsBox mvex : movieExtendsBoxes) {
                List<TrackExtendsBox> trackExtendsBoxes = mvex.getBoxes(TrackExtendsBox.class);
                for (TrackExtendsBox trex : trackExtendsBoxes) {
                    if (trex.getTrackId() != trackId) continue;
                    LinkedList<Long> syncSampleList = new LinkedList<Long>();
                    long sampleNumber = 1L;
                    for (MovieFragmentBox movieFragmentBox : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                        List<TrackFragmentBox> trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                        for (TrackFragmentBox traf : trafs) {
                            if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                            List<TrackRunBox> truns = traf.getBoxes(TrackRunBox.class);
                            for (TrackRunBox trun : truns) {
                                TrackFragmentHeaderBox tfhd = ((TrackFragmentBox)trun.getParent()).getTrackFragmentHeaderBox();
                                boolean first = true;
                                for (TrackRunBox.Entry entry : trun.getEntries()) {
                                    SampleFlags sampleFlags;
                                    Object e;
                                    if (trun.isSampleDurationPresent()) {
                                        if (this.decodingTimeEntries.size() == 0 || this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1).getDelta() != entry.getSampleDuration()) {
                                            this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, entry.getSampleDuration()));
                                        } else {
                                            e = this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1);
                                            ((TimeToSampleBox.Entry)e).setCount(((TimeToSampleBox.Entry)e).getCount() + 1L);
                                        }
                                    } else if (tfhd.hasDefaultSampleDuration()) {
                                        this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, tfhd.getDefaultSampleDuration()));
                                    } else {
                                        this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, trex.getDefaultSampleDuration()));
                                    }
                                    if (trun.isSampleCompositionTimeOffsetPresent()) {
                                        if (this.compositionTimeEntries.size() == 0 || this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1).getOffset() != entry.getSampleCompositionTimeOffset()) {
                                            this.compositionTimeEntries.add(new CompositionTimeToSample.Entry(1, CastUtils.l2i(entry.getSampleCompositionTimeOffset())));
                                        } else {
                                            e = this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1);
                                            ((CompositionTimeToSample.Entry)e).setCount(((CompositionTimeToSample.Entry)e).getCount() + 1);
                                        }
                                    }
                                    if ((sampleFlags = trun.isSampleFlagsPresent() ? entry.getSampleFlags() : (first && trun.isFirstSampleFlagsPresent() ? trun.getFirstSampleFlags() : (tfhd.hasDefaultSampleFlags() ? tfhd.getDefaultSampleFlags() : trex.getDefaultSampleFlags()))) != null && !sampleFlags.isSampleIsDifferenceSample()) {
                                        syncSampleList.add(sampleNumber);
                                    }
                                    ++sampleNumber;
                                    first = false;
                                }
                            }
                        }
                    }
                    long[] oldSS = this.syncSamples;
                    this.syncSamples = new long[this.syncSamples.length + syncSampleList.size()];
                    System.arraycopy(oldSS, 0, this.syncSamples, 0, oldSS.length);
                    Iterator iterator = syncSampleList.iterator();
                    int i = oldSS.length;
                    while (iterator.hasNext()) {
                        Long syncSampleNumber = (Long)iterator.next();
                        this.syncSamples[i++] = syncSampleNumber;
                    }
                }
            }
        }
        MediaHeaderBox mdhd = trackBox.getMediaBox().getMediaHeaderBox();
        TrackHeaderBox tkhd = trackBox.getTrackHeaderBox();
        this.setEnabled(tkhd.isEnabled());
        this.setInMovie(tkhd.isInMovie());
        this.setInPoster(tkhd.isInPoster());
        this.setInPreview(tkhd.isInPreview());
        this.trackMetaData.setTrackId(tkhd.getTrackId());
        this.trackMetaData.setCreationTime(mdhd.getCreationTime());
        this.trackMetaData.setLanguage(mdhd.getLanguage());
        this.trackMetaData.setModificationTime(mdhd.getModificationTime());
        this.trackMetaData.setTimescale(mdhd.getTimescale());
        this.trackMetaData.setHeight(tkhd.getHeight());
        this.trackMetaData.setWidth(tkhd.getWidth());
        this.trackMetaData.setLayer(tkhd.getLayer());
        this.trackMetaData.setMatrix(tkhd.getMatrix());
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.decodingTimeEntries;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.compositionTimeEntries;
    }

    @Override
    public long[] getSyncSamples() {
        return this.syncSamples;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sampleDependencies;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.mihd;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    public String toString() {
        return "Mp4TrackImpl{handler='" + this.handler + '\'' + '}';
    }
}

