/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.presentation;

import android.content.Context;
import android.net.Uri;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSourceFactory;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.ui.PlayerView;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.StreamPlayerClient;
import com.ekoapp.sdk.streamplayer.R;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableInterval;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\u0006\u0010!\u001a\u00020\u001cJ\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0006\u0010'\u001a\u00020\u001cJ\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u001cH\u0002J\u0006\u0010.\u001a\u00020\u001cJ\b\u0010/\u001a\u00020\u001cH\u0002J\b\u00100\u001a\u00020\u001cH\u0002J!\u00101\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u00102\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u00103R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/amity/socialcloud/sdk/video/presentation/AmityVideoPlayer;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "duration", "", "durationDisposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "exoplayer", "Landroidx/media3/exoplayer/ExoPlayer;", "isStopWhenPause", "", "isStopped", "isVideoPlaying", "sessionId", "", "startedAt", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "title", "enableStopWhenPause", "", "getDataSourceFactory", "Landroidx/media3/datasource/DataSource$Factory;", "inflateView", "initPlayer", "pause", "play", "streamId", "url", "prepareCounting", "prepareVideo", "resume", "seekToLastWhenResume", "isPlaying", "starCounting", "partialStreamData", "Lcom/amity/socialcloud/sdk/streamapi/PartialStreamData;", "startInterval", "stop", "stopCounting", "syncPendingSession", "updateStreamSession", "endedAt", "(Ljava/lang/Long;Lorg/joda/time/DateTime;)V", "amity-video-player_release"})
@UnstableApi
public final class AmityVideoPlayer
extends LinearLayout {
    @Nullable
    private ExoPlayer exoplayer;
    private boolean isStopped;
    private boolean isVideoPlaying;
    private boolean isStopWhenPause;
    private DateTime startedAt;
    private long duration;
    @Nullable
    private Disposable durationDisposable;
    @NotNull
    private String title;
    @Nullable
    private String sessionId;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    public AmityVideoPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public AmityVideoPlayer(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        this._$_findViewCache = new LinkedHashMap();
        super(context, attrs);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public AmityVideoPlayer(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        this._$_findViewCache = new LinkedHashMap();
        super(context, attrs, defStyleAttr);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    private final void inflateView() {
        LinearLayout.inflate((Context)this.getContext(), (int)R.layout.view_amity_video_player, (ViewGroup)((ViewGroup)this));
    }

    public final void play(@NotNull String streamId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.initPlayer();
        this.prepareVideo(url);
        this.prepareCounting(streamId);
    }

    public final void stop() {
        ExoPlayer exoPlayer = this.exoplayer;
        if (exoPlayer != null) {
            exoPlayer.stop();
        }
        this.stopCounting();
    }

    public final void pause() {
        block1: {
            ExoPlayer exoPlayer = this.exoplayer;
            if (exoPlayer != null) {
                exoPlayer.setPlayWhenReady(false);
            }
            ExoPlayer exoPlayer2 = this.exoplayer;
            if (exoPlayer2 == null) break block1;
            exoPlayer2.getPlaybackState();
        }
    }

    public final void resume() {
        block1: {
            ExoPlayer exoPlayer = this.exoplayer;
            if (exoPlayer != null) {
                exoPlayer.setPlayWhenReady(true);
            }
            ExoPlayer exoPlayer2 = this.exoplayer;
            if (exoPlayer2 == null) break block1;
            exoPlayer2.getPlaybackState();
        }
    }

    public final void enableStopWhenPause() {
        this.isStopWhenPause = true;
    }

    private final void initPlayer() {
        ExoPlayer exoPlayer = this.exoplayer = new ExoPlayer.Builder(this.getContext()).build();
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(true);
        }
        ExoPlayer exoPlayer2 = this.exoplayer;
        if (exoPlayer2 != null) {
            exoPlayer2.addListener(new Player.Listener(this){
                final /* synthetic */ AmityVideoPlayer this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onIsPlayingChanged(boolean isPlaying) {
                    AmityVideoPlayer.access$setVideoPlaying$p(this.this$0, isPlaying);
                    if (AmityVideoPlayer.access$isStopWhenPause$p(this.this$0)) {
                        AmityVideoPlayer.access$seekToLastWhenResume(this.this$0, isPlaying);
                    }
                }
            });
        }
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
        boolean bl = false;
        ExoPlayer exoPlayer3 = this.exoplayer;
        if (exoPlayer3 != null) {
            exoPlayer3.setAudioAttributes(audioAttributes, true);
        }
        ((PlayerView)this._$_findCachedViewById(R.id.amity_video_viewer)).setPlayer((Player)this.exoplayer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void seekToLastWhenResume(boolean isPlaying) {
        if (isPlaying) {
            ExoPlayer exoPlayer = this.exoplayer;
            boolean bl = exoPlayer != null ? exoPlayer.getPlaybackState() == 3 : false;
            if (bl) {
                if (!this.isStopped) return;
                ExoPlayer exoPlayer2 = this.exoplayer;
                if (exoPlayer2 != null) {
                    exoPlayer2.seekTo(Long.MAX_VALUE);
                }
                this.isStopped = false;
                return;
            }
        }
        if (isPlaying) return;
        ExoPlayer exoPlayer = this.exoplayer;
        if (!(exoPlayer != null ? exoPlayer.getPlaybackState() == 3 : false)) return;
        this.isStopped = true;
    }

    private final void prepareVideo(String url) {
        block0: {
            String newUrl = StringsKt.replace$default((String)url, (String)"https", (String)"http", (boolean)false, (int)4, null);
            ((PlayerView)this._$_findCachedViewById(R.id.amity_video_viewer)).requestFocus();
            MediaItem mediaItem = MediaItem.fromUri((Uri)Uri.parse((String)newUrl));
            Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"fromUri(Uri.parse(newUrl))");
            MediaItem mediaItem2 = mediaItem;
            ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory(this.getDataSourceFactory(), (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(mediaItem2);
            Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"Factory(getDataSourceFac\u2026ateMediaSource(mediaItem)");
            MediaSource videoSource = (MediaSource)progressiveMediaSource;
            ExoPlayer exoPlayer = this.exoplayer;
            if (exoPlayer == null) break block0;
            exoPlayer.prepare(videoSource);
        }
    }

    private final DataSource.Factory getDataSourceFactory() {
        return (DataSource.Factory)new DefaultDataSourceFactory(this.getContext(), Util.getUserAgent((Context)this.getContext(), (String)((Object)((Object)this)).getClass().getSimpleName()));
    }

    private final void prepareCounting(String streamId) {
        if (this.durationDisposable == null) {
            StreamPlayerClient.Companion.getFunction().getStreamData(streamId).subscribeOn(Schedulers.io()).doOnSuccess(arg_0 -> AmityVideoPlayer.prepareCounting$lambda-1(this, arg_0)).subscribe();
        }
    }

    private final void starCounting(PartialStreamData partialStreamData) {
        StreamFunctionInterface streamFunctionInterface = StreamPlayerClient.Companion.getFunction();
        String string = partialStreamData.getStreamId();
        DateTime dateTime = this.startedAt;
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"startedAt");
        streamFunctionInterface.createStreamSession(string, this.title, dateTime, partialStreamData.getResolution()).subscribeOn(Schedulers.io()).subscribe(arg_0 -> AmityVideoPlayer.starCounting$lambda-2(this, arg_0));
    }

    private final void startInterval() {
        this.startedAt = DateTime.now();
        this.durationDisposable = new FlowableInterval(0L, 1L, TimeUnit.SECONDS, Schedulers.io()).filter(arg_0 -> AmityVideoPlayer.startInterval$lambda-3(this, arg_0)).map(arg_0 -> AmityVideoPlayer.startInterval$lambda-4(this, arg_0)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnNext(arg_0 -> AmityVideoPlayer.startInterval$lambda-5(this, arg_0)).subscribe();
    }

    private final void stopCounting() {
        Disposable disposable = this.durationDisposable;
        boolean bl = disposable != null ? !disposable.isDisposed() : false;
        if (bl) {
            Disposable disposable2 = this.durationDisposable;
            if (disposable2 != null) {
                disposable2.dispose();
            }
            if (this.duration > 0L) {
                DateTime endedAt = DateTime.now();
                String startTimeText = ((Object)DateFormat.format((CharSequence)"MMMM dd yyyy, h:mm aa", (long)this.startedAt.getMillis())).toString();
                String endTimeText = ((Object)DateFormat.format((CharSequence)"MMMM dd yyyy, h:mm aa", (long)endedAt.getMillis())).toString();
                String summaryText = " Start time : " + startTimeText + "\n End time : " + endTimeText + "\n Duration in second : " + this.duration;
                this.updateStreamSession(this.duration, endedAt);
                this.syncPendingSession();
            }
        }
    }

    private final void updateStreamSession(Long duration, DateTime endedAt) {
        block0: {
            String string = this.sessionId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            StreamPlayerClient.Companion.getFunction().updateStreamSession(it, duration, endedAt).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    private final void syncPendingSession() {
        StreamPlayerClient.Companion.getFunction().syncPendingSession();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void prepareCounting$lambda-1(AmityVideoPlayer this$0, PartialStreamData it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (it.isLive()) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this$0.starCounting(it);
        }
    }

    private static final void starCounting$lambda-2(AmityVideoPlayer this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sessionId = it;
        this$0.startInterval();
    }

    private static final boolean startInterval$lambda-3(AmityVideoPlayer this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.isVideoPlaying;
    }

    private static final Long startInterval$lambda-4(AmityVideoPlayer this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        long l = this$0.duration;
        this$0.duration = l + 1L;
        return l;
    }

    private static final void startInterval$lambda-5(AmityVideoPlayer this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        DateTime endedAt = DateTime.now();
        this$0.updateStreamSession(it, endedAt);
    }

    public static final /* synthetic */ void access$setVideoPlaying$p(AmityVideoPlayer $this, boolean bl) {
        $this.isVideoPlaying = bl;
    }

    public static final /* synthetic */ boolean access$isStopWhenPause$p(AmityVideoPlayer $this) {
        return $this.isStopWhenPause;
    }

    public static final /* synthetic */ void access$seekToLastWhenResume(AmityVideoPlayer $this, boolean isPlaying) {
        $this.seekToLastWhenResume(isPlaying);
    }
}

