package com.amity.socialcloud.sdk.streamapi

import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

interface StreamFunctionInterface {

    fun createStreamSession(
        streamId: String,
        title: String,
        startedAt: DateTime,
        resolution: String
    ): Single<String>

    fun updateStreamSession(sessionId: String, duration: Long?, endedAt: DateTime?): Completable

    fun getStreamData(streamId: String): Single<PartialStreamData>

    fun syncPendingSession()

    fun createVideoStreaming(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null,
        isSecure: Boolean? = null
    ): Single<Pair<String, String>>

    fun disposeVideoStreaming(streamId: String): Completable
}