/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.stream;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H'J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH'J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH'J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH'J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H'J\b\u0010\u0016\u001a\u00020\u0005H\u0017J\b\u0010\u0017\u001a\u00020\u0005H'J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH'J\u0016\u0010\u001a\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001eH'\u00a8\u0006\u001f"}, d2={"Lcom/amity/socialcloud/sdk/video/data/stream/EkoStreamDao;", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "Lcom/amity/socialcloud/sdk/entity/video/stream/EkoStreamEntity;", "()V", "deleteAll", "", "getById", "Lio/reactivex/rxjava3/core/Flowable;", "streamId", "", "getByIdImpl", "getByIdNow", "getByIdNowImpl", "getByIdsNow", "", "streamIds", "getByIdsNowImpl", "getLatestStream", "statuses", "getLatestStreamImpl", "now", "Lorg/joda/time/DateTime;", "softDelete", "softDeleteImpl", "updateStream", "updateStreamImpl", "updateStreamIsBanned", "isBanned", "", "updateStreamIsBannedImpl", "", "amity-sdk_release"})
@Dao
public abstract class EkoStreamDao
extends EkoObjectDao<EkoStreamEntity> {
    @Query(value="SELECT * from stream where streamId = :streamId")
    @NotNull
    public abstract Flowable<EkoStreamEntity> getByIdImpl(@Nullable String var1);

    @NotNull
    public final Flowable<EkoStreamEntity> getById(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        return this.getByIdImpl(streamId);
    }

    @Query(value="SELECT * from stream where streamId = :streamId")
    @Nullable
    public abstract EkoStreamEntity getByIdNowImpl(@NotNull String var1);

    @Override
    @Nullable
    public EkoStreamEntity getByIdNow(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        return this.getByIdNowImpl(streamId);
    }

    @Query(value="SELECT * from stream where streamId  in (:streamIds)")
    @NotNull
    public abstract List<EkoStreamEntity> getByIdsNowImpl(@NotNull List<String> var1);

    @Override
    @NotNull
    public List<EkoStreamEntity> getByIdsNow(@NotNull List<String> streamIds) {
        Intrinsics.checkNotNullParameter(streamIds, (String)"streamIds");
        return this.getByIdsNowImpl(streamIds);
    }

    @Query(value="UPDATE stream set isDeleted = 1 where isDeleted = 0")
    public abstract void softDeleteImpl();

    @Query(value="UPDATE stream set isBanned = :isBanned where streamId = :streamId")
    public abstract void updateStreamIsBannedImpl(@NotNull String var1, int var2);

    public final void updateStreamIsBanned(@NotNull String streamId, boolean isBanned) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        this.updateStreamIsBannedImpl(streamId, isBanned ? 1 : 0);
    }

    @Transaction
    public void softDelete() {
        this.softDeleteImpl();
    }

    @Override
    @Query(value="DELETE from stream")
    public abstract void deleteAll();

    @NotNull
    public final Flowable<EkoStreamEntity> getLatestStream(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now()");
        return this.getLatestStreamImpl(statuses, dateTime);
    }

    @Query(value="SELECT * from stream where status in (:statuses) and stream.updatedAt > :now and stream.isParent = 1 order by stream.updatedAt DESC limit 1")
    @NotNull
    public abstract Flowable<EkoStreamEntity> getLatestStreamImpl(@NotNull List<String> var1, @NotNull DateTime var2);

    @Transaction
    public void updateStream(@NotNull String streamId) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        this.updateStreamImpl(streamId);
    }

    @Query(value="UPDATE stream set streamId = :streamId where streamId = :streamId")
    public abstract void updateStreamImpl(@NotNull String var1);
}

