package com.amity.socialcloud.sdk.core.data.notificationtray.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao

@Dao
internal interface AmityNotificationTrayItemPagingDao : QueryStreamPagingDao<NotificationTrayItemEntity> {
    @RawQuery(observedEntities = [NotificationTrayItemEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, NotificationTrayItemEntity>


    fun queryNotificationTrayItems(): PagingSource<Int, NotificationTrayItemEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "notificationTrayItem",
                primaryKeyColumnName = "notificationId",
                queryStreamKeyCreator = NotificationTrayKeyCreator(),
                nonce = AmityNonce.NOTIFICATION_TRAY,
                order = AmityPagingDao.Order.ASC
            )
        )
    }
}