package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity
import com.ekoapp.ekosdk.internal.api.dto.ChannelMarkerDto
import org.joda.time.DateTime

internal class ChannelMarkerEntityMapper : EntityMapper<ChannelMarkerDto, ChannelMarkerEntity>() {

    override fun map(list: List<ChannelMarkerDto>): List<ChannelMarkerEntity> {
        return list.map { map(it) }
    }

    fun map(dto: ChannelMarkerDto) : ChannelMarkerEntity {
        return ChannelMarkerEntity().apply {
            channelId = dto.channelId
            userId = dto.userId
            unreadCount = if (dto.isDeleted) 0 else dto.unreadCount
            isDeleted = dto.isDeleted
            hasMentioned = dto.hasMentioned
            createdAt = dto.createdAt ?: DateTime.now()
            updatedAt = dto.updatedAt ?: DateTime.now()
        }
    }

}