package com.ekoapp.ekosdk.internal.usecase.invitation

import com.amity.socialcloud.sdk.core.data.invitation.InvitationRepository
import com.amity.socialcloud.sdk.core.domain.invitation.InvitationComposerUseCase
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import io.reactivex.rxjava3.core.Single

internal class GetCommunityInvitationUseCase {

    fun execute(communityId: String): Single<List<AmityInvitation>> {
        return InvitationRepository().getMyCommunityInvitation(communityId)
            .map { invitations ->
                invitations.map(InvitationComposerUseCase()::execute)
            }
    }

}