package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

class GlobalFeedKeyCreator(private val dataTypes: List<AmityPost.DataType>) :
    QueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "isDeleted" to false,
            "dataTypes" to PostRepositoryHelper.convertPostTypesToString(dataTypes)
        )
    }

    override fun optionalFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(
    ): String {
        //post is not deleted filter
        val postIsNotDelete = "post.isDeleted = 0"

        //compose all condition
        return postIsNotDelete
    }
}