package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.MessagePreviewEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto

internal class MessageUpdated : MessageEventListener() {

    override fun getEventName(): String {
        return "message.updated"
    }
    
    override fun processEvent(dto: MessageQueryDto) {
        super.processEvent(dto)
        dto.messages.map { message ->
            dto.subChannels.find { it.subChannelId == message.subChannelId }?.let {subChannel ->
                MessagePreviewEvent.MessageUpdated(message,subChannel).let(MessagePreviewEventBus::publish)
            }
        }
    }

}
