package com.amity.socialcloud.sdk.core.data.file

import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto
import com.ekoapp.ekosdk.internal.api.socket.request.FileUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.PUT
import retrofit2.http.Path

interface FileApi {

    @DELETE("api/v3/files/{fileId}")
    fun deleteFile(
        @Path("fileId") fileId: String
    ): Single<EkoFileDto>

    @GET("api/v3/files/{fileId}")
    fun getFile(
        @Path("fileId") fileId: String
    ): Single<EkoFileDto>

    @PUT("api/v3/files/{fileId}")
    fun updateFile(
        @Path("fileId") fileId: String,
        @Body request: FileUpdateRequest,
    ): Single<EkoFileDto>

}