package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.domain.marker.channel.SaveChannelMarkerUseCase
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.ChannelMarkerQueryDto
import io.reactivex.rxjava3.core.Completable

internal class ChannelMarkerQueryPersister : QueryPersister<ChannelMarkerQueryDto>() {

    override fun persist(dto: ChannelMarkerQueryDto): Completable {
        return SaveChannelMarkerUseCase().execute(ChannelMarkerEntityMapper().map(dto.channelMarkers))
                .andThen(UserMarkerLocalDataStore().saveUserMarkers(UserMarkerEntityMapper().map(dto.userMarkers)))
                .andThen(Completable.fromCallable {
                    dto.channelMarkers.map { channelMarkerDto ->
                        ChannelRepository().updateMarkerHash(channelMarkerDto.channelId,channelMarkerDto.hashCode())
                    }
                })
    }

}