package com.amity.socialcloud.sdk.social.data.community.paging

import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class CommunityQueryKeyCreator(
    private val keyword: String,
    private val categoryId: String,
    private val filter: AmityCommunityFilter,
    private val sortOption: AmityCommunitySortOption,
    private val isDeleted: Boolean?,
    private val includeDiscoverablePrivateCommunity: Boolean,
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "keyword" to keyword,
            "filter" to filter,
            "categoryId" to categoryId,
            "sortOption" to sortOption.apiKey,
            "isDeleted" to (isDeleted?.toString() ?: "null"),
            "includeDiscoverablePrivateCommunity" to (includeDiscoverablePrivateCommunity.toString())
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            categoryId,
            filter,
            isDeleted,
            includeDiscoverablePrivateCommunity
        )
    }

    private fun getConditionStatement(
        categoryId: String,
        filter: AmityCommunityFilter,
        isDeleted: Boolean?,
        includeDiscoverablePrivateCommunity: Boolean,
    ): String {
        // default filter
        val defaultFilterStatement = "community.communityId is not null"

        // categoryId filter
        val categoryIdFilterStatement = if (categoryId.isBlank()) {
            ""
        } else {
            " and community.communityId in (SELECT communityId from category where categoryId = '${categoryId}')"
        }

        // isJoined filter
        val isJoinedFilterStatement = when (filter) {
            AmityCommunityFilter.ALL -> {
                ""
            }

            AmityCommunityFilter.MEMBER -> {
                " and community.isJoined = 1"
            }

            AmityCommunityFilter.NOT_MEMBER -> {
                " and community.isJoined = 0"
            }
        }

        // isDeleted filter
        val isDeletedFilterStatement = when (isDeleted) {
            null -> {
                ""
            }

            true -> {
                " and community.isDeleted = 1"
            }

            false -> {
                " and community.isDeleted = 0"
            }
        }

        // includeDiscoverablePrivateCommunity filter
        val isDiscoverablePrivateCommunityFilterStatement =
            when (includeDiscoverablePrivateCommunity) {
                true -> {
                    " and community.isDiscoverable = 1"
                }

                false -> {
                    " and community.isPublic = 1"
                }
            }

        return defaultFilterStatement +
                categoryIdFilterStatement +
                isJoinedFilterStatement +
                isDeletedFilterStatement
                isDiscoverablePrivateCommunityFilterStatement
    }

}