package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.message.MessageEventPersister
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import io.reactivex.rxjava3.schedulers.Schedulers

internal class MessageReactionRemoved : MessageEventListener() {

    override fun processEvent(dto: MessageQueryDto) {
        val reactor = dto.reactions.first()
        reactor?.eventName = "remove"
        dto.apply {
            this.messages.first()?.latestReaction = reactor
        }
        MessageEventPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                AmityLog.e(it)
            }
            .subscribe()

    }

    override fun getEventName(): String {
        return "message.reactionRemoved"
    }

}
