package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.ekoapp.ekosdk.EkoFlag
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.internal.EkoLocalFlag
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.google.common.base.Objects
import com.google.gson.annotations.SerializedName
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

@Entity(tableName = "message_flag",
		primaryKeys = ["messageId"],
)
data class EkoMessageFlag constructor(
	val messageId: String,
	@SerializedName("hashFlag")
	var flag: EkoFlag? = null,
	var localFlag: EkoLocalFlag? = null
) : EkoObject() {
	
	override fun getId(): String {
		return messageId
	}
	
	val isFlaggedByMe: Boolean
		get() {
			flag?.let { flag ->
				val mightFlaggedByMe = flag.mightFlaggedByMe()
				val local = localFlag ?: EkoLocalFlag().apply {
					localFlag = this
				}
				if (mightFlaggedByMe && !Objects.equal(flag.hash, local.syncedUpHash)) {
					Single.just(messageId)
						.filter { id: String -> flag.expired(id) }
						.flatMapSingle { messageId: String -> MessageRepository().isFlaggedByMe(messageId) }
						.doOnSuccess { isFlaggedByMe: Boolean ->
							local.isFlaggedByMe = isFlaggedByMe
							local.syncedUpHash = flag.hash
							localFlag = local
							UserDatabase.get().messageFlagDao().update(this@EkoMessageFlag)
						}
						.doOnError {
							// see if log is needed
						}
						.subscribe()
					return true
				}
				return mightFlaggedByMe && local.isFlaggedByMe
			} ?: localFlag?.let {
				Completable.fromAction {
					localFlag = null
					UserDatabase.get().messageFlagDao().update(this@EkoMessageFlag)
				}.subscribeOn(Schedulers.io())
					.doOnError {
						// see if log is needed
					}
					.subscribe()
			}
			return false
		}
	
	override fun equals(obj: Any?): Boolean {
		return (super.equals(obj)
				&& Objects.equal(flag, (obj as EkoMessageFlag).flag)
				&& Objects.equal(localFlag, obj.localFlag))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(super.hashCode(), flag, localFlag)
	}

}