package com.amity.socialcloud.sdk.chat.data.message.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.EkoMessageEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface MessagePagingDao : DynamicQueryStreamPagingDao<EkoMessageEntity> {

    @RawQuery(observedEntities = [EkoMessageEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoMessageEntity>

    fun getMessagePagingSource(
        subChannelId: String,
        isFilterByParentId: Boolean,
        parentId: String?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isDeleted: Boolean?,
        sortOption: AmityMessageQuerySortOption,
        dataType: String?,
        aroundMessageId: String?,
        uniqueId: String? = null,
    ): PagingSource<Int, EkoMessageEntity> {
        val order = if(sortOption == AmityMessageQuerySortOption.LAST_CREATED) AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC
        val sortColumns = mutableListOf<AmityPagingDao.Sorting>().apply {
            add(
                AmityPagingDao.Sorting.Enum(
                    tableName = "message",
                    columnName = "syncState",
                    enumList = listOf(AmityMessage.State.FAILED,AmityMessage.State.CREATED,AmityMessage.State.UPLOADING,AmityMessage.State.SYNCING,AmityMessage.State.SYNCED).map { it.stateName },
                )
            )
            add(
                AmityPagingDao.Sorting.Column(
                    tableName = "message",
                    columnName = "channelSegment",
                    order = order,
                )
            )
            add(
                AmityPagingDao.Sorting.Column(
                    tableName = "message",
                    columnName = "createdAt",
                    order = order,
                )
            )
        }
        
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "message",
                primaryKeyColumnName = "uniqueId",
                nonce = AmityNonce.MESSAGE_LIST,
                order = order,
                sortColumns= sortColumns,
                dynamicQueryStreamKeyCreator = MessageKeyCreator(
                    subChannelId = subChannelId,
                    parentId = parentId,
                    isFilterByParentId = isFilterByParentId,
                    includingTags = includingTags,
                    excludingTags = excludingTags,
                    isDeleted = isDeleted,
                    sortOption = sortOption,
                    dataType = dataType,
                    aroundMessageId = aroundMessageId,
                    uniqueId = uniqueId,
                )
            )
        )
    }

}