package com.ekoapp.ekosdk.internal.usecase.message

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository
import com.amity.socialcloud.sdk.core.domain.user.UserComposerUseCase
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetMessageReadUsersUseCase {

    @OptIn(ExperimentalPagingApi::class)
    fun execute(
        messageId: String,
        memberships: List<MessageReadMembershipFilter>,
    ): Flowable<PagingData<AmityUser>> {
        return MessageMarkerRepository().getMessageReadUsers(messageId, memberships)
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) {
                    UserComposerUseCase().execute(it)
                }
            }
    }
}