package com.amity.socialcloud.sdk.infra.upload

import com.ekoapp.ekosdk.internal.data.converter.EkoGson
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName

data class SocketResponse(
    @SerializedName("status")
    val status: String,
    @SerializedName("message")
    val message: String,
    @SerializedName("code")
    val code: Int,
    @SerializedName("data")
    val data: JsonObject
) {
    enum class Status(val json: String) {
        SUCCESS("success"), ERROR("error");

        companion object {
            fun fromJson(jsonValue: String?): Status {
                for (status in values()) {
                    if (status.json == jsonValue) {
                        return status
                    }
                }
                return ERROR
            }
        }
    }
    val isSuccess: Boolean
        get() {
            val status = Status.fromJson(status)
            return Objects.equal(status, Status.SUCCESS)
        }

    fun <T> getData(dataType: Class<T>): T {
        return EkoGson.get().fromJson(data, dataType)
    }

    override fun toString(): String {
        return MoreObjects.toStringHelper(this)
            .omitNullValues()
            .add("status", status)
            .add("message", message)
            .add("code", code)
            .add("data", data)
            .toString()
    }
}