/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.story;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.social.data.story.StoryDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class StoryDao_Impl
extends StoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StoryEntity> __insertionAdapterOfStoryEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<StoryEntity> __deletionAdapterOfStoryEntity;
    private final EntityDeletionOrUpdateAdapter<StoryEntity> __updateAdapterOfStoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteStory;
    private final SharedSQLiteStatement __preparedStmtOfHardDeleteStory;
    private final SharedSQLiteStatement __preparedStmtOfDummyUpdateStory;
    private final SharedSQLiteStatement __preparedStmtOfDecrementCommentCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdateSyncState;
    private final SharedSQLiteStatement __preparedStmtOfInitSyncStateOnStartup;

    public StoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStoryEntity = new EntityInsertionAdapter<StoryEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `story` (`uniqueId`,`storyId`,`path`,`dataType`,`data`,`metadata`,`items`,`reactions`,`reactionCount`,`commentCount`,`flagCount`,`storyExpiresAt`,`isDeleted`,`targetType`,`targetId`,`creatorId`,`impression`,`reach`,`syncState`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, StoryEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getStoryId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getStoryId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPath());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDataType());
                }
                String _tmp = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = StoryDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(value.getItems());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                String _tmp_3 = StoryDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                stmt.bindLong(9, (long)value.getReactionCount());
                stmt.bindLong(10, (long)value.getCommentCount());
                stmt.bindLong(11, (long)value.getFlagCount());
                String _tmp_4 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getStoryExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                int _tmp_5 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_5);
                if (value.getTargetType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getTargetId());
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getCreatorId());
                }
                stmt.bindLong(17, (long)value.getImpression());
                stmt.bindLong(18, (long)value.getReach());
                if (value.getSyncState() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getSyncState());
                }
                String _tmp_6 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_6);
                }
                String _tmp_7 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                String _tmp_8 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_8);
                }
            }
        };
        this.__deletionAdapterOfStoryEntity = new EntityDeletionOrUpdateAdapter<StoryEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `story` WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, StoryEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfStoryEntity = new EntityDeletionOrUpdateAdapter<StoryEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `story` SET `uniqueId` = ?,`storyId` = ?,`path` = ?,`dataType` = ?,`data` = ?,`metadata` = ?,`items` = ?,`reactions` = ?,`reactionCount` = ?,`commentCount` = ?,`flagCount` = ?,`storyExpiresAt` = ?,`isDeleted` = ?,`targetType` = ?,`targetId` = ?,`creatorId` = ?,`impression` = ?,`reach` = ?,`syncState` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, StoryEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getStoryId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getStoryId());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPath());
                }
                if (value.getDataType() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDataType());
                }
                String _tmp = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getData());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                String _tmp_1 = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = StoryDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(value.getItems());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                String _tmp_3 = StoryDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(value.getReactions());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                stmt.bindLong(9, (long)value.getReactionCount());
                stmt.bindLong(10, (long)value.getCommentCount());
                stmt.bindLong(11, (long)value.getFlagCount());
                String _tmp_4 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getStoryExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                int _tmp_5 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(13, (long)_tmp_5);
                if (value.getTargetType() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTargetType());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getTargetId());
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getCreatorId());
                }
                stmt.bindLong(17, (long)value.getImpression());
                stmt.bindLong(18, (long)value.getReach());
                if (value.getSyncState() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getSyncState());
                }
                String _tmp_6 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_6);
                }
                String _tmp_7 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, _tmp_7);
                }
                String _tmp_8 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_8);
                }
                if (value.getUniqueId() == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, value.getUniqueId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from story";
                return "delete from story";
            }
        };
        this.__preparedStmtOfSoftDeleteStory = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE story set isDeleted = 1 where storyId = ?";
                return "UPDATE story set isDeleted = 1 where storyId = ?";
            }
        };
        this.__preparedStmtOfHardDeleteStory = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from story where storyId = ?";
                return "DELETE from story where storyId = ?";
            }
        };
        this.__preparedStmtOfDummyUpdateStory = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update story set storyId = ? where storyId = ?";
                return "update story set storyId = ? where storyId = ?";
            }
        };
        this.__preparedStmtOfDecrementCommentCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE story set commentCount = commentCount - 1 where storyId = ?";
                return "UPDATE story set commentCount = commentCount - 1 where storyId = ?";
            }
        };
        this.__preparedStmtOfUpdateSyncState = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update story set syncState = ? where uniqueId = ?";
                return "update story set syncState = ? where uniqueId = ?";
            }
        };
        this.__preparedStmtOfInitSyncStateOnStartup = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE story set syncState = 'failed' where syncState = 'syncing'";
                return "UPDATE story set syncState = 'failed' where syncState = 'syncing'";
            }
        };
    }

    @Override
    public void insertImpl(StoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfStoryEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends StoryEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfStoryEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(StoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfStoryEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends StoryEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfStoryEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(StoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfStoryEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(StoryEntity object) {
        this.__db.beginTransaction();
        try {
            StoryDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends StoryEntity> objects) {
        this.__db.beginTransaction();
        try {
            StoryDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(StoryEntity object) {
        this.__db.beginTransaction();
        try {
            StoryDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Completable softDeleteStory(final String storyId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryDao_Impl.this.__preparedStmtOfSoftDeleteStory.acquire();
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, storyId);
                }
                StoryDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryDao_Impl.this.__db.endTransaction();
                    StoryDao_Impl.this.__preparedStmtOfSoftDeleteStory.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable hardDeleteStory(final String storyId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryDao_Impl.this.__preparedStmtOfHardDeleteStory.acquire();
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, storyId);
                }
                StoryDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryDao_Impl.this.__db.endTransaction();
                    StoryDao_Impl.this.__preparedStmtOfHardDeleteStory.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hardDeleteNow(String storyId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfHardDeleteStory.acquire();
        int _argIndex = 1;
        if (storyId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, storyId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfHardDeleteStory.release(_stmt);
        }
    }

    @Override
    public Completable dummyUpdateStory(final String storyId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryDao_Impl.this.__preparedStmtOfDummyUpdateStory.acquire();
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, storyId);
                }
                _argIndex = 2;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, storyId);
                }
                StoryDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryDao_Impl.this.__db.endTransaction();
                    StoryDao_Impl.this.__preparedStmtOfDummyUpdateStory.release(_stmt);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementCommentCount(String storyId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDecrementCommentCount.acquire();
        int _argIndex = 1;
        if (storyId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, storyId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDecrementCommentCount.release(_stmt);
        }
    }

    @Override
    public Completable updateSyncState(final String uniqueId, final String syncState) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryDao_Impl.this.__preparedStmtOfUpdateSyncState.acquire();
                int _argIndex = 1;
                if (syncState == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, syncState);
                }
                _argIndex = 2;
                if (uniqueId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, uniqueId);
                }
                StoryDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryDao_Impl.this.__db.endTransaction();
                    StoryDao_Impl.this.__preparedStmtOfUpdateSyncState.release(_stmt);
                }
            }
        });
    }

    @Override
    public void initSyncStateOnStartup() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfInitSyncStateOnStartup.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfInitSyncStateOnStartup.release(_stmt);
        }
    }

    @Override
    public Flowable<StoryEntity> getStory(String storyId) {
        String _sql = "select * from story where storyId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from story where storyId = ?", (int)1);
        int _argIndex = 1;
        if (storyId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, storyId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"story"}, (Callable)new Callable<StoryEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StoryEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StoryEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfStoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfItems = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"items");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyExpiresAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfImpression = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"impression");
                    int _cursorIndexOfReach = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reach");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new StoryEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpStoryId = _cursor.isNull(_cursorIndexOfStoryId) ? null : _cursor.getString(_cursorIndexOfStoryId);
                        _result.setStoryId(_tmpStoryId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        _result.setDataType(_tmpDataType);
                        String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = StoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setData(_tmpData);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = StoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfItems) ? null : _cursor.getString(_cursorIndexOfItems);
                        JsonArray _tmpItems = StoryDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                        _result.setItems(_tmpItems);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = StoryDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfStoryExpiresAt);
                        DateTime _tmpStoryExpiresAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_5 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        int _tmpImpression = _cursor.getInt(_cursorIndexOfImpression);
                        _result.setImpression(_tmpImpression);
                        int _tmpReach = _cursor.getInt(_cursorIndexOfReach);
                        _result.setReach(_tmpReach);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    StoryEntity storyEntity = _result;
                    return storyEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoryEntity getByIdNowImpl(String uniqueId) {
        String _sql = "select * from story where uniqueId = ? limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from story where uniqueId = ? limit 1", (int)1);
        int _argIndex = 1;
        if (uniqueId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uniqueId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            StoryEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfStoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfItems = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"items");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyExpiresAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfImpression = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"impression");
            int _cursorIndexOfReach = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reach");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new StoryEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpStoryId = _cursor.isNull(_cursorIndexOfStoryId) ? null : _cursor.getString(_cursorIndexOfStoryId);
                _result.setStoryId(_tmpStoryId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                _result.setDataType(_tmpDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setData(_tmpData);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _result.setMetadata(_tmpMetadata);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfItems) ? null : _cursor.getString(_cursorIndexOfItems);
                JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                _result.setItems(_tmpItems);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _result.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfStoryExpiresAt);
                DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                _result.setCreatorId(_tmpCreatorId);
                int _tmpImpression = _cursor.getInt(_cursorIndexOfImpression);
                _result.setImpression(_tmpImpression);
                int _tmpReach = _cursor.getInt(_cursorIndexOfReach);
                _result.setReach(_tmpReach);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            StoryEntity storyEntity = _result;
            return storyEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<StoryEntity> getLatestStoryImpl(String targetType, String targetId, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from story where story.targetType = ? and story.targetId = ?  and story.updatedAt > ? and story.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by story.updatedAt  desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from story where story.targetType = ? and story.targetId = ?  and story.updatedAt > ? and story.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by story.updatedAt  desc limit 1", (int)5);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        _argIndex = 3;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"story", "amity_paging_id"}, (Callable)new Callable<StoryEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StoryEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StoryEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfStoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfItems = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"items");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyExpiresAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfImpression = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"impression");
                    int _cursorIndexOfReach = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reach");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new StoryEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpStoryId = _cursor.isNull(_cursorIndexOfStoryId) ? null : _cursor.getString(_cursorIndexOfStoryId);
                        _result.setStoryId(_tmpStoryId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        _result.setDataType(_tmpDataType);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = StoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        _result.setData(_tmpData);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = StoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfItems) ? null : _cursor.getString(_cursorIndexOfItems);
                        JsonArray _tmpItems = StoryDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_3);
                        _result.setItems(_tmpItems);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = StoryDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfStoryExpiresAt);
                        DateTime _tmpStoryExpiresAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_6 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        int _tmpImpression = _cursor.getInt(_cursorIndexOfImpression);
                        _result.setImpression(_tmpImpression);
                        int _tmpReach = _cursor.getInt(_cursorIndexOfReach);
                        _result.setReach(_tmpReach);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    StoryEntity storyEntity = _result;
                    return storyEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUniqueIdByStoryIdImpl(String storyId) {
        String _sql = "SELECT story.uniqueId from story where story.storyId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT story.uniqueId from story where story.storyId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (storyId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, storyId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            String _result = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<StoryEntity> observeStoryImpl(String storyId) {
        String _sql = "SELECT story.* from story where story.storyId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT story.* from story where story.storyId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (storyId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, storyId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"story"}, (Callable)new Callable<StoryEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StoryEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StoryEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfStoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyId");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfItems = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"items");
                    int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
                    int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
                    int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
                    int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
                    int _cursorIndexOfStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyExpiresAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
                    int _cursorIndexOfImpression = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"impression");
                    int _cursorIndexOfReach = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reach");
                    int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new StoryEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpStoryId = _cursor.isNull(_cursorIndexOfStoryId) ? null : _cursor.getString(_cursorIndexOfStoryId);
                        _result.setStoryId(_tmpStoryId);
                        String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                        _result.setPath(_tmpPath);
                        String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                        _result.setDataType(_tmpDataType);
                        String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                        JsonObject _tmpData = StoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setData(_tmpData);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = StoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                        _result.setMetadata(_tmpMetadata);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfItems) ? null : _cursor.getString(_cursorIndexOfItems);
                        JsonArray _tmpItems = StoryDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                        _result.setItems(_tmpItems);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                        AmityReactionMap _tmpReactions = StoryDao_Impl.this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                        _result.setReactions(_tmpReactions);
                        int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                        _result.setReactionCount(_tmpReactionCount);
                        int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                        _result.setCommentCount(_tmpCommentCount);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfStoryExpiresAt);
                        DateTime _tmpStoryExpiresAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_5 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        int _tmpImpression = _cursor.getInt(_cursorIndexOfImpression);
                        _result.setImpression(_tmpImpression);
                        int _tmpReach = _cursor.getInt(_cursorIndexOfReach);
                        _result.setReach(_tmpReach);
                        String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                        _result.setSyncState(_tmpSyncState);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = StoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    StoryEntity storyEntity = _result;
                    return storyEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoryEntity getByStoryIdNowImpl(String storyId) {
        String _sql = "SELECT story.* from story where story.storyId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT story.* from story where story.storyId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (storyId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, storyId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            StoryEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfStoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfItems = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"items");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyExpiresAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfImpression = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"impression");
            int _cursorIndexOfReach = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reach");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new StoryEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpStoryId = _cursor.isNull(_cursorIndexOfStoryId) ? null : _cursor.getString(_cursorIndexOfStoryId);
                _result.setStoryId(_tmpStoryId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                _result.setDataType(_tmpDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setData(_tmpData);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _result.setMetadata(_tmpMetadata);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfItems) ? null : _cursor.getString(_cursorIndexOfItems);
                JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                _result.setItems(_tmpItems);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _result.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _result.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _result.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfStoryExpiresAt);
                DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                _result.setCreatorId(_tmpCreatorId);
                int _tmpImpression = _cursor.getInt(_cursorIndexOfImpression);
                _result.setImpression(_tmpImpression);
                int _tmpReach = _cursor.getInt(_cursorIndexOfReach);
                _result.setReach(_tmpReach);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _result.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            StoryEntity storyEntity = _result;
            return storyEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getHighestStoryExpiresAt(String targetType, String targetId, List<String> syncStates) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT storyExpiresAt from story where targetType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and targetId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and syncState IN (");
        int _inputSize = syncStates.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") order by storyExpiresAt DESC LIMIT 1");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        _argIndex = 3;
        for (String _item : syncStates) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            DateTime _result;
            if (_cursor.moveToFirst()) {
                String _tmp = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
            } else {
                _result = null;
            }
            DateTime dateTime = _result;
            return dateTime;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStoryCount(String targetType, String targetId, List<String> syncStates) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT COUNT(*) from story where targetType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and targetId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and syncState IN (");
        int _inputSize = syncStates.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 2 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        _argIndex = 3;
        for (String _item : syncStates) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoryEntity> findCache(String targetType, String targetId) {
        String _sql = "SELECT story.* from story where targetType = ? and targetId = ? and syncState != 'synced'";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT story.* from story where targetType = ? and targetId = ? and syncState != 'synced'", (int)2);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfStoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyId");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfDataType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dataType");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfItems = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"items");
            int _cursorIndexOfReactions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactions");
            int _cursorIndexOfReactionCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reactionCount");
            int _cursorIndexOfCommentCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentCount");
            int _cursorIndexOfFlagCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flagCount");
            int _cursorIndexOfStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storyExpiresAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfCreatorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"creatorId");
            int _cursorIndexOfImpression = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"impression");
            int _cursorIndexOfReach = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reach");
            int _cursorIndexOfSyncState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"syncState");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<StoryEntity> _result = new ArrayList<StoryEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                StoryEntity _item = new StoryEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _item.setUniqueId(_tmpUniqueId);
                String _tmpStoryId = _cursor.isNull(_cursorIndexOfStoryId) ? null : _cursor.getString(_cursorIndexOfStoryId);
                _item.setStoryId(_tmpStoryId);
                String _tmpPath = _cursor.isNull(_cursorIndexOfPath) ? null : _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpDataType = _cursor.isNull(_cursorIndexOfDataType) ? null : _cursor.getString(_cursorIndexOfDataType);
                _item.setDataType(_tmpDataType);
                String _tmp = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item.setData(_tmpData);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                _item.setMetadata(_tmpMetadata);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfItems) ? null : _cursor.getString(_cursorIndexOfItems);
                JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                _item.setItems(_tmpItems);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfReactions) ? null : _cursor.getString(_cursorIndexOfReactions);
                AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                _item.setReactions(_tmpReactions);
                int _tmpReactionCount = _cursor.getInt(_cursorIndexOfReactionCount);
                _item.setReactionCount(_tmpReactionCount);
                int _tmpCommentCount = _cursor.getInt(_cursorIndexOfCommentCount);
                _item.setCommentCount(_tmpCommentCount);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item.setFlagCount(_tmpFlagCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfStoryExpiresAt);
                DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _item.setStoryExpiresAt(_tmpStoryExpiresAt);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                _item.setDeleted(_tmpIsDeleted);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _item.setTargetType(_tmpTargetType);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _item.setTargetId(_tmpTargetId);
                String _tmpCreatorId = _cursor.isNull(_cursorIndexOfCreatorId) ? null : _cursor.getString(_cursorIndexOfCreatorId);
                _item.setCreatorId(_tmpCreatorId);
                int _tmpImpression = _cursor.getInt(_cursorIndexOfImpression);
                _item.setImpression(_tmpImpression);
                int _tmpReach = _cursor.getInt(_cursorIndexOfReach);
                _item.setReach(_tmpReach);
                String _tmpSyncState = _cursor.isNull(_cursorIndexOfSyncState) ? null : _cursor.getString(_cursorIndexOfSyncState);
                _item.setSyncState(_tmpSyncState);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _item.setExpiresAt(_tmpExpiresAt);
                _result.add(_item);
            }
            ArrayList<StoryEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

