/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.joda.time.DateTime;

@Dao
public abstract class EkoCommentDao
extends EkoObjectDao<CommentEntity> {
    @Query(value="SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = :referenceType  and comment.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and comment.referenceId = :referenceId and comment.commentId = comment_flag.commentId order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc")
    abstract DataSource.Factory<Integer, CommentEntity> getAllImpl(String var1, String var2, Boolean var3, Boolean var4);

    public DataSource.Factory<Integer, CommentEntity> getAll(String referenceType, String referenceId, Boolean isDeleted, AmityCommentSortOption sortOption) {
        return this.getAllImpl(referenceType, referenceId, isDeleted, this.isSortByCreatedACS(sortOption));
    }

    @Query(value="SELECT comment.* from comment where comment.commentId in (:commentIds)  order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc")
    abstract Flowable<List<CommentEntity>> getAllByIdsImpl(List<String> var1, Boolean var2);

    public Flowable<List<CommentEntity>> getAllByIds(List<String> commentIds, AmityCommentSortOption sortOption) {
        return this.getAllByIdsImpl(commentIds, this.isSortByCreatedACS(sortOption));
    }

    @Query(value="SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = :referenceType and comment.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and comment.referenceId = :referenceId and comment.parentId = :parentId and comment.commentId = comment_flag.commentId order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc")
    abstract DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String var1, String var2, String var3, Boolean var4, Boolean var5);

    @Query(value="SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = :referenceType and comment.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and comment.referenceId = :referenceId and comment.parentId is null and comment.commentId = comment_flag.commentId order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc")
    abstract DataSource.Factory<Integer, CommentEntity> getAllByParentIdImpl(String var1, String var2, Boolean var3, Boolean var4);

    @Query(value="SELECT * from comment, amity_paging_id where comment.referenceType = :referenceType and comment.referenceId = :referenceId and comment.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and comment.parentId is null and comment.updatedAt > :now and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by comment.updatedAt  desc limit 1")
    abstract Flowable<CommentEntity> getLatestParentCommentImpl(String var1, String var2, Boolean var3, int var4, int var5, DateTime var6);

    @Query(value="SELECT * from comment, amity_paging_id where comment.referenceType = :referenceType and comment.referenceId = :referenceId and comment.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and comment.parentId = :parentId and comment.updatedAt > :now and comment.commentId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by comment.createdAt  desc limit 1")
    abstract Flowable<CommentEntity> getLatestChildCommentImpl(String var1, String var2, String var3, Boolean var4, int var5, int var6, DateTime var7);

    public Flowable<CommentEntity> getLatestComment(String referenceType, String referenceId, @Nullable String parentId, Boolean isDeleted, int hash, int nonce) {
        if (parentId != null) {
            return this.getLatestChildCommentImpl(referenceType, referenceId, parentId, isDeleted, hash, nonce, DateTime.now());
        }
        return this.getLatestParentCommentImpl(referenceType, referenceId, isDeleted, hash, nonce, DateTime.now());
    }

    public DataSource.Factory<Integer, CommentEntity> getAllByParentId(String referenceType, String referenceId, String parentId, Boolean isDeleted, AmityCommentSortOption sortOption) {
        if (parentId != null) {
            return this.getAllByParentIdImpl(referenceType, referenceId, parentId, isDeleted, this.isSortByCreatedACS(sortOption));
        }
        return this.getAllByParentIdImpl(referenceType, referenceId, isDeleted, this.isSortByCreatedACS(sortOption));
    }

    @Query(value="SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.referenceType = :referenceType and comment.referenceId = :referenceId and comment.commentId = comment_flag.commentId and comment.isDeleted = 0 and comment.parentId is null order by createdAt DESC LIMIT 5")
    abstract List<CommentEntity> getLatestCommentsImpl(String var1, String var2);

    public List<CommentEntity> getLatestComments(String referenceType, String referenceId) {
        return this.getLatestCommentsImpl(referenceType, referenceId);
    }

    @Query(value="SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.parentId = :parentId and comment.referenceId = :referenceId and comment.referenceType = :referenceType and comment.commentId = comment_flag.commentId order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc LIMIT 5")
    abstract List<CommentEntity> getLatestRepliesImpl(String var1, String var2, String var3, boolean var4);

    public List<CommentEntity> getLatestReplies(String parentId, String referenceType, String referenceId, AmityCommentSortOption sortBy) {
        return this.getLatestRepliesImpl(parentId, referenceType, referenceId, this.isSortByCreatedACS(sortBy));
    }

    @Query(value="SELECT * from comment where comment.referenceType = :referenceType and comment.referenceId = :referenceId and comment.createdAt > :offsetCommentTime order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc")
    abstract Flowable<List<CommentEntity>> observeCommentAfterImpl(String var1, String var2, boolean var3, DateTime var4);

    @Query(value="SELECT * from comment where comment.referenceType = :referenceType and comment.referenceId = :referenceId and comment.parentId = :parentId and comment.createdAt > :offsetCommentTime order by case when :isSortByCreatedACS = 1 then comment.createdAt end asc, case when :isSortByCreatedACS = 0 then comment.createdAt end desc")
    abstract Flowable<List<CommentEntity>> observeCommentAfterFilterByParentImpl(String var1, String var2, String var3, boolean var4, DateTime var5);

    public Flowable<List<CommentEntity>> observeCommentAfter(String referenceType, String referenceId, String parentId, boolean isFilterByParentId, AmityCommentSortOption sortOption, String offsetCommentId) {
        if (isFilterByParentId) {
            return this.observeCommentAfterFilterByParentImpl(referenceType, referenceId, parentId, this.isSortByCreatedACS(sortOption), this.getCommentOffsetTime(offsetCommentId));
        }
        return this.observeCommentAfterImpl(referenceType, referenceId, this.isSortByCreatedACS(sortOption), this.getCommentOffsetTime(offsetCommentId));
    }

    @Deprecated
    @Query(value="SELECT createdAt from comment where commentId = :commentId")
    public abstract DateTime getCommentCreatedTime(String var1);

    private DateTime getCommentOffsetTime(String commentId) {
        if (commentId == null) {
            return DateTime.now();
        }
        return this.getCommentCreatedTime(commentId);
    }

    @Query(value="SELECT * from comment where comment.commentId = :id LIMIT 1")
    abstract CommentEntity getByIdNowImpl(String var1);

    @Override
    public CommentEntity getByIdNow(@NonNull String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT * from comment where comment.commentId IN (:ids)")
    abstract List<CommentEntity> getByIdsNowImpl(List<String> var1);

    @Override
    @NonNull
    public List<CommentEntity> getByIdsNow(@NonNull List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Query(value="SELECT comment.*, comment_flag.commentId as flag_commentId, comment_flag.flag as flag_flag, comment_flag.localFlag as flag_localFlag from comment, comment_flag where comment.commentId = :commentId and comment.commentId = comment_flag.commentId LIMIT 1")
    abstract Flowable<CommentEntity> getByIdImpl(String var1);

    public Flowable<CommentEntity> getById(String commentId) {
        return this.getByIdImpl(commentId);
    }

    @Query(value="UPDATE comment set syncState = 'failed' where syncState = 'syncing'")
    public abstract void initSyncStateOnStartup();

    @Override
    @Query(value="DELETE from comment")
    public abstract void deleteAll();

    @Query(value="UPDATE comment set isDeleted = 1 where commentId = :commentId")
    public abstract Completable softDeleteById(String var1);

    @Query(value="DELETE from comment where commentId = :commentId")
    public abstract Completable deleteById(String var1);

    @Query(value="DELETE from comment where referenceId = :referenceId")
    public abstract Completable deleteByReferenceId(String var1);

    private Boolean isSortByCreatedACS(AmityCommentSortOption sortBy) {
        return sortBy == AmityCommentSortOption.FIRST_CREATED;
    }

    @Query(value="UPDATE comment set commentId = commentId where commentId = :commentId")
    public abstract void updateComment(String var1);

    public void markAllDeletedBeforeCommentId(String commentId) {
        CommentEntity comment = this.getByIdNow(commentId);
        if (comment != null) {
            this.markAllDeletedBeforeCreatedAt(comment.getParentId() != null, comment.getCreatedAt());
        }
    }

    public void markAllDeletedAfterCommentId(String commentId) {
        CommentEntity comment = this.getByIdNow(commentId);
        if (comment != null) {
            this.markAllDeletedAfterCreatedAt(comment.getParentId() != null, comment.getCreatedAt());
        }
    }

    @Query(value="UPDATE comment set isDeleted = 1 where createdAt < :createdAt and parentId = (case when :isReply = 1 then parentId is not null else parentId is null end)")
    public abstract void markAllDeletedBeforeCreatedAt(Boolean var1, DateTime var2);

    @Query(value="UPDATE comment set isDeleted = 1 where createdAt > :createdAt and parentId = (case when :isReply = 1 then parentId is not null else parentId is null end)")
    public abstract void markAllDeletedAfterCreatedAt(Boolean var1, DateTime var2);

    public Flowable<List<CommentEntity>> getByCommentIds(List<String> ids) {
        return this.getByCommentIdsImpl(ids);
    }

    @Query(value="SELECT * from comment where comment.commentId IN (:commentIds)")
    abstract Flowable<List<CommentEntity>> getByCommentIdsImpl(List<String> var1);
}

