package com.amity.socialcloud.sdk.core

import com.amity.socialcloud.sdk.model.chat.settings.AmityMessagePreviewSetting
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto

sealed class MessagePreviewEvent {
	class MessageCreated(val message: EkoMessageDto, val subChannel: SubChannelDto): MessagePreviewEvent()
	class MessageUpdated(val message: EkoMessageDto, val subChannel: SubChannelDto): MessagePreviewEvent()
	class MessageDeleted(val message: EkoMessageDto, val subChannel: SubChannelDto): MessagePreviewEvent()
	class SubChannelUpdated(val subChannel: SubChannelDto): MessagePreviewEvent()
	class SubChannelDeleted(val subChannel: SubChannelDto): MessagePreviewEvent()
	class MessagePreviewSettingChange(val messagePreviewSetting: AmityMessagePreviewSetting):  MessagePreviewEvent()
	
	companion object {
		fun isMessageEvent(event: MessagePreviewEvent): Boolean {
			return event is MessageCreated || event is MessageUpdated || event is MessageDeleted
		}
		
		fun isSubChannelEvent(event: MessagePreviewEvent): Boolean {
			return event is SubChannelUpdated || event is SubChannelDeleted
		}
	}
	
}