package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import io.reactivex.rxjava3.core.Flowable

internal class GetChannelsUseCase {

    fun execute(
        channelIds: List<String>
    ): Flowable<List<AmityChannel>> {
        return ChannelRepository().getChannels(channelIds)
            .map { channels ->
                channels.map(ChannelComposerUseCase()::execute)
            }
            .map {
                it.filter { channel ->
                    try {
                        !channel.membership().getMyMembership().blockingFirst().isBanned()
                    } catch(e: Exception) {
                        // If fail to get membership status will include it to the collection
                        true
                    }
                }
            }
    }
}