package com.amity.socialcloud.sdk.social.data.community.paging

import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

class CommunityJoinRequestKeyCreator(
    private val communityId: String,
    private val status: String,
    private val sortBy: AmityCommunitySortOption? = null,
    private val targetType: String,
    private val type: String,
) : QueryStreamKeyCreator {
    override fun toMap(): Map<String, Any> {
        return mapOf(
            "targetId" to communityId,
            "status" to status,
            "sortBy" to (sortBy?.apiKey ?: ""),
            "targetType" to targetType,
            "type" to type
        )
    }

    override fun optionalFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        // default filter
        val defaultFilterStatement = "joinRequest.targetId is not null"

        // communityId filter
        val communityIdFilterStatement = if (communityId.isBlank()) {
            ""
        } else {
            " and joinRequest.targetId = '${communityId}'"
        }

        // status filter
        val statusFilterStatement = if (status.isBlank()) {
            ""
        } else {
            " and joinRequest.status = '${status}'"
        }
//
//        // targetType filter
//        val targetTypeFilterStatement = if (targetType.isBlank()) {
//            ""
//        } else {
//            " and joinRequest.targetType = '${targetType}'"
//        }
//
//        // type filter
//        val typeFilterStatement = if (type.isBlank()) {
//            ""
//        } else {
//            " and joinRequest.type = '${type}'"
//        }

        return defaultFilterStatement +
                communityIdFilterStatement +
                statusFilterStatement //+
//                targetTypeFilterStatement +
//                typeFilterStatement
    }
}
