package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.social.post.AmityPostAttachment
import com.google.common.collect.FluentIterable

internal interface PostCreateUseCase {

    fun mapMentionees(userIds: List<String>?): List<AmityMentioneeTarget>? {
        return if (userIds.isNullOrEmpty()) {
            null
        } else {
            listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
        }
    }

    fun mapAttachments(
        files: List<AmityFileInfo>,
        dataType: String,
        fileId: String? = null,
        displayMode: String? = null,
        isMuted: Boolean? = null,
    ): List<AmityPostAttachment> {
        return FluentIterable.from(files)
            .transform { file ->
                AmityPostAttachment(
                    fileId = fileId ?: file!!.getFileId(),
                    type = dataType,
                    displayMode = displayMode,
                    isMuted = isMuted
                )
            }
            .toList()
    }

}