package com.amity.socialcloud.sdk.core.domain.shareablelink

import com.amity.socialcloud.sdk.core.data.shareablelink.ShareableLinkRepository
import com.amity.socialcloud.sdk.model.core.shareablelink.AmityShareableLinkConfiguration
import io.reactivex.rxjava3.core.Single

class GetShareableLinkUseCase {
    fun execute(): Single<AmityShareableLinkConfiguration> {
        return ShareableLinkRepository().getShareableLink()
            .map { shareableLinkData ->
                AmityShareableLinkConfiguration(
                    shareableLinkData.domain,
                    shareableLinkData.patterns
                )
            }
    }
}