package com.amity.socialcloud.sdk.core.data.reaction

import com.amity.socialcloud.sdk.core.data.reaction.dto.ReactionAddedDto
import com.amity.socialcloud.sdk.core.data.reaction.dto.ReactionRemovedDto
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.AddLiveReactionsRequest
import com.ekoapp.ekosdk.internal.api.socket.request.AddReactionRequest
import com.ekoapp.ekosdk.internal.api.socket.request.LiveReactionRequest
import com.ekoapp.ekosdk.internal.api.socket.request.RemoveReactionRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class ReactionRemoteDataStore {

    fun getReactions(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String? = null,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoReactionAndUserListDto> {
        var actualReactionName = reactionName
        if (reactionName?.isEmpty() == true) {
            actualReactionName = null
        }
        return AmityHttpClient.get(ReactionApi::class).flatMap {
            it.queryReactions(
                referenceType = referenceType.value,
                referenceId = referenceId,
                reactionName = actualReactionName,
                referenceVersion = if (referenceType == AmityReactionReferenceType.MESSAGE) 5 else null,
                limit = limit,
                token = token
            )
        }
    }

    fun addReaction(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String
    ): Single<ReactionAddedDto> {
        return Single.fromCallable {
            AddReactionRequest(
                referenceType = referenceType.value,
                referenceId = referenceId,
                reactionName = reactionName,
                referenceVersion = if (referenceType == AmityReactionReferenceType.MESSAGE) 5 else null
            )
        }.flatMap { request ->
            AmityHttpClient.get(ReactionApi::class).flatMap {
                it.addReaction(request)
            }
        }
    }

    fun removeReaction(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String
    ): Single<ReactionRemovedDto> {
        return Single.fromCallable {
            RemoveReactionRequest(
                referenceType = referenceType.value,
                referenceId = referenceId,
                reactionName = reactionName,
                referenceVersion = if (referenceType == AmityReactionReferenceType.MESSAGE) 5 else null
            )
        }.flatMap { request ->
            AmityHttpClient.get(ReactionApi::class).flatMap {
                it.removeReaction(request)
            }
        }
    }

    fun addLiveReactions(
        liveStreamId: String,
        reactions: List<AmityLiveReaction>
    ): Single<JsonObject> {
        return Single.fromCallable {
            AddLiveReactionsRequest(
                liveStreamId = liveStreamId,
                reactions = reactions.map { reaction ->
                    LiveReactionRequest(
                        referenceType = reaction.getReferenceType(),
                        referencePublicId = reaction.getReferenceId(),
                        reactionName = reaction.getReactionName(),
                        occurredAt = reaction.getOccurredAt()
                    )
                }
            )
        }.flatMap { request ->
            AmityHttpClient.get(ReactionApi::class).flatMap {
                it.addLiveReactions(request)
            }
        }
    }

}